/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.IOException;
import java.util.Stack;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.pkg.rdfa.JenaSink;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OdfFileSaxHandler
extends DefaultHandler {
    private static final String EMPTY_STRING = "";
    private OdfFileDom mFileDom;
    private Node mNode;
    private Stack<ContentHandler> mHandlerStack = new Stack();
    private StringBuilder mCharsForTextNode = new StringBuilder();
    private JenaSink sink;

    OdfFileSaxHandler(Node rootNode) {
        this.mFileDom = rootNode instanceof OdfFileDom ? (OdfFileDom)((Object)rootNode) : (OdfFileDom)((Object)rootNode.getOwnerDocument());
        this.mNode = rootNode;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushTextNode();
        this.mNode = this.mNode.getParentNode();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushTextNode();
        OdfElement element = null;
        element = uri.equals(EMPTY_STRING) || qName.equals(EMPTY_STRING) ? this.mFileDom.createElement(localName) : this.mFileDom.createElementNS(uri, qName);
        String attrQname = null;
        String attrURL = null;
        OdfAttribute attr = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrURL = attributes.getURI(i);
            attrQname = attributes.getQName(i);
            if (attrURL.equals(EMPTY_STRING) || attrQname.equals(EMPTY_STRING)) {
                attr = this.mFileDom.createAttribute(attributes.getLocalName(i));
            } else {
                if (attrQname.startsWith("xmlns:")) {
                    OdfNamespace namespace = this.mFileDom.setNamespace(attributes.getLocalName(i), attributes.getValue(i));
                    OdfElement root = this.mFileDom.getRootElement();
                    if (root == null) {
                        root = element;
                    }
                    root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.getPrefix(), namespace.getUri());
                }
                attr = this.mFileDom.createAttributeNS(attrURL, attrQname);
            }
            if (attr == null) continue;
            element.setAttributeNodeNS((Attr)((Object)attr));
            try {
                attr.setValue(attributes.getValue(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                element.removeAttributeNode((Attr)((Object)attr));
            }
        }
        this.mNode.appendChild((Node)((Object)element));
        this.mNode = element;
        if (!localName.equals("bookmark-start")) {
            this.setContextNode(this.mNode);
        }
    }

    private void flushTextNode() {
        if (this.mCharsForTextNode.length() > 0) {
            Text text = this.mFileDom.createTextNode(this.mCharsForTextNode.toString());
            this.mNode.appendChild(text);
            this.mCharsForTextNode.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.mHandlerStack.empty()) {
            this.mHandlerStack.peek().characters(ch, start, length);
        } else {
            this.mCharsForTextNode.append(ch, start, length);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return super.resolveEntity(publicId, systemId);
    }

    private void setContextNode(Node node) {
        if (this.sink != null) {
            this.sink.setContextNode(node);
        }
    }

    public void setSink(JenaSink sink) {
        this.sink = sink;
    }
}

