/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.infoletter.implementation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.internet.InternetAddress;
import javax.transaction.Transactional;
import org.silverpeas.components.infoletter.InfoLetterContentManager;
import org.silverpeas.components.infoletter.InfoLetterException;
import org.silverpeas.components.infoletter.model.InfoLetter;
import org.silverpeas.components.infoletter.model.InfoLetterPublication;
import org.silverpeas.components.infoletter.model.InfoLetterPublicationPdC;
import org.silverpeas.components.infoletter.model.InfoLetterService;
import org.silverpeas.components.infoletter.model.InfoLetterTemplateContributionWrapper;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformer;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.mail.ReceiverMailAddressSet;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.service.ComponentSubscription;
import org.silverpeas.core.subscription.service.ComponentSubscriptionResource;
import org.silverpeas.core.subscription.service.GroupSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.service.UserSubscriptionSubscriber;
import org.silverpeas.core.subscription.util.SubscriptionList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Named(value="infoLetterService")
public class InfoLetterDataManager
implements InfoLetterService {
    private static final String MESSAGES_PATH = "org.silverpeas.infoLetter.multilang.infoLetterBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.infoLetter.settings.infoLetterSettings";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.infoLetter.settings.infoLetterSettings");
    private static final String TABLE_EXTERNAL_EMAILS = "SC_IL_ExtSus";
    private static final String INSTANCE_ID = "instanceId";
    private final SilverpeasBeanDAO<InfoLetter> infoLetterDAO;
    private final SilverpeasBeanDAO<InfoLetterPublication> infoLetterPublicationDAO;
    @Inject
    private InfoLetterContentManager infoLetterContentManager;

    public <T extends Contribution> Optional<T> getContributionById(ContributionIdentifier contributionId) {
        if ("publication".equals(contributionId.getType())) {
            String localId = contributionId.getLocalId();
            IdPK pk = new IdPK(localId);
            return Optional.ofNullable(this.getInfoLetterPublication((WAPrimaryKey)pk));
        }
        if ("Lettre".equals(contributionId.getType())) {
            return this.getInfoLetters(contributionId.getComponentInstanceId()).stream().map(InfoLetterTemplateContributionWrapper::new).findFirst();
        }
        throw new IllegalStateException(MessageFormat.format("type {0} is not handled", contributionId.getType()));
    }

    public SettingBundle getComponentSettings() {
        return settings;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("infoLetter");
    }

    public InfoLetterDataManager() {
        try {
            this.infoLetterDAO = SilverpeasBeanDAOFactory.getDAO(InfoLetter.class);
            this.infoLetterPublicationDAO = SilverpeasBeanDAOFactory.getDAO(InfoLetterPublication.class);
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
    }

    @Override
    public void createInfoLetter(InfoLetter il) {
        try {
            WAPrimaryKey pk = this.infoLetterDAO.add((SilverpeasEntityBean)il);
            il.setPK(pk);
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
    }

    @Override
    public void updateInfoLetter(InfoLetter ie) {
        try {
            this.infoLetterDAO.update((SilverpeasEntityBean)ie);
            this.deleteIndex(ie);
            this.createIndex(ie);
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
    }

    @Override
    public List<InfoLetter> getInfoLetters(String instanceId) {
        BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId);
        try {
            return new ArrayList<InfoLetter>(this.infoLetterDAO.findBy(criteria));
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
    }

    @Override
    public List<InfoLetterPublication> getInfoLetterPublications(WAPrimaryKey letterPK) {
        try {
            InfoLetter letter = this.getInfoLetter(letterPK);
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)letter.getInstanceId()).and("letterId", (Object)Integer.parseInt(letterPK.getId()));
            criteria.setDescOrderBy(new String[]{"id"});
            return new ArrayList<InfoLetterPublication>(this.infoLetterPublicationDAO.findBy(criteria));
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
    }

    @Override
    public void createInfoLetterPublication(InfoLetterPublicationPdC ilp, String userId) {
        Connection con = this.openConnection();
        try {
            WAPrimaryKey pk = this.infoLetterPublicationDAO.add(con, (SilverpeasEntityBean)ilp);
            ilp.setPK(pk);
            this.infoLetterContentManager.createSilverContent(con, (Contribution)ilp, userId);
        }
        catch (Exception pe) {
            DBUtil.rollback((Connection)con);
            throw new InfoLetterException(pe);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void deleteInfoLetterPublication(WAPrimaryKey pk, String componentId) {
        try (Connection con = this.openConnection();){
            this.infoLetterPublicationDAO.remove(pk);
            this.infoLetterContentManager.deleteSilverContent(con, pk.getId(), componentId);
            InfoLetterPublication entity = new InfoLetterPublication((WAPrimaryKey)new ResourceReference(pk.getId(), componentId), componentId, null, null, null, 0, 0);
            this.deleteIndex(entity);
            entity.deleteContent();
        }
        catch (Exception pe) {
            throw new InfoLetterException(pe);
        }
    }

    @Override
    public void updateInfoLetterPublication(InfoLetterPublicationPdC ilp) {
        try {
            this.infoLetterPublicationDAO.update((SilverpeasEntityBean)ilp);
            this.infoLetterContentManager.updateSilverContentVisibility((Contribution)ilp);
            if (ilp.isValid()) {
                this.deleteIndex(ilp);
                this.createIndex(ilp);
            }
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
    }

    @Override
    public InfoLetter getInfoLetter(WAPrimaryKey letterPK) {
        InfoLetter infoLetter;
        try {
            infoLetter = (InfoLetter)this.infoLetterDAO.findByPrimaryKey(letterPK);
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
        return infoLetter;
    }

    @Override
    public InfoLetterPublicationPdC getInfoLetterPublication(WAPrimaryKey publiPK) {
        InfoLetterPublicationPdC classifiedPublic;
        try {
            classifiedPublic = new InfoLetterPublicationPdC((InfoLetterPublication)this.infoLetterPublicationDAO.findByPrimaryKey(publiPK));
        }
        catch (PersistenceException pe) {
            throw new InfoLetterException(pe);
        }
        return classifiedPublic;
    }

    @Override
    public InfoLetter createDefaultLetter(String componentId) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        ComponentInst ci = oc.getComponentInst(componentId);
        InfoLetter ie = new InfoLetter();
        ie.setInstanceId(componentId);
        ie.setName(ci.getLabel());
        this.createInfoLetter(ie);
        this.initTemplate(componentId, ie.getPK(), "0");
        return ie;
    }

    @Override
    public void deleteAllInfoLetters(String componentId) {
        try (Connection connection = this.openConnection();){
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)componentId);
            this.infoLetterPublicationDAO.removeBy(connection, criteria);
            this.infoLetterDAO.removeBy(connection, criteria);
            try (PreparedStatement statement = connection.prepareStatement("delete from SC_IL_ExtSus where instanceId = ?");){
                statement.setString(1, componentId);
                statement.execute();
            }
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
    }

    @Override
    public int getSilverObjectId(String pubId, String componentId) {
        try {
            int silverObjectId = this.infoLetterContentManager.getSilverContentId(pubId, componentId);
            if (silverObjectId == -1) {
                IdPK publiPK = new IdPK();
                publiPK.setId(pubId);
                InfoLetterPublicationPdC infoLetter = this.getInfoLetterPublication((WAPrimaryKey)publiPK);
                silverObjectId = this.infoLetterContentManager.createSilverContent(null, (Contribution)infoLetter, infoLetter.getCreatorId());
            }
            return silverObjectId;
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
    }

    @Override
    public SubscriptionSubscriberList getInternalSuscribers(String componentId) {
        return ResourceSubscriptionProvider.getSubscribersOfComponent((String)componentId);
    }

    @Override
    public void setInternalSuscribers(String componentId, UserDetail[] users, Group[] groups) {
        ArrayList<ComponentSubscription> subscriptions = new ArrayList<ComponentSubscription>(users.length + groups.length);
        for (UserDetail userDetail : users) {
            subscriptions.add(new ComponentSubscription((SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userDetail.getId()), componentId));
        }
        for (UserDetail userDetail : groups) {
            subscriptions.add(new ComponentSubscription((SubscriptionSubscriber)GroupSubscriptionSubscriber.from((String)userDetail.getId()), componentId));
        }
        SubscriptionList subscriptionsToDelete = SubscriptionServiceProvider.getSubscribeService().getByResource((SubscriptionResource)ComponentSubscriptionResource.from((String)componentId));
        subscriptionsToDelete.removeAll(subscriptions);
        SubscriptionServiceProvider.getSubscribeService().unsubscribe((Collection)subscriptionsToDelete);
        SubscriptionServiceProvider.getSubscribeService().subscribe(subscriptions);
    }

    @Override
    public Set<String> getEmailsExternalsSuscribers(WAPrimaryKey letterPK) {
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        try (Connection con = this.openConnection();){
            InfoLetter letter = this.getInfoLetter(letterPK);
            String selectQuery = "SELECT * FROM SC_IL_ExtSus where instanceId = ? and letter = ?";
            try (PreparedStatement selectStmt = con.prepareStatement(selectQuery);){
                selectStmt.setString(1, letter.getInstanceId());
                selectStmt.setInt(2, Integer.parseInt(letterPK.getId()));
                try (ResultSet rs = selectStmt.executeQuery();){
                    while (rs.next()) {
                        emails.add(rs.getString("email"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
        return emails;
    }

    @Override
    @Transactional
    public void setEmailsExternalsSubscribers(WAPrimaryKey letterPK, Set<String> emails) {
        try (Connection con = this.openConnection();){
            InfoLetter letter = this.getInfoLetter(letterPK);
            int letterId = Integer.parseInt(letterPK.getId());
            JdbcSqlQuery.deleteFrom((String)TABLE_EXTERNAL_EMAILS).where("instanceId = ?", new Object[]{letter.getInstanceId()}).and("letter = ?", new Object[]{letterId}).executeWith(con);
            for (String email : emails) {
                JdbcSqlQuery.insertInto((String)TABLE_EXTERNAL_EMAILS).withInsertParam("letter", (Object)letterId).withInsertParam("email", (Object)email).withInsertParam(INSTANCE_ID, (Object)letter.getInstanceId()).executeWith(con);
            }
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
    }

    @Override
    public void toggleSuscriber(String userId, String componentId, boolean isUserSubscribing) {
        ComponentSubscription subscription = new ComponentSubscription((SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId), componentId);
        if (isUserSubscribing) {
            SubscriptionServiceProvider.getSubscribeService().subscribe((Subscription)subscription);
        } else {
            SubscriptionServiceProvider.getSubscribeService().unsubscribe((Subscription)subscription);
        }
    }

    @Override
    public boolean isUserSuscribed(String userId, String componentId) {
        return SubscriptionServiceProvider.getSubscribeService().existsSubscription((Subscription)new ComponentSubscription((SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId), componentId));
    }

    @Override
    public void initTemplate(String componentId, WAPrimaryKey letterPK, String userId) {
        try {
            String basicTemplate = "<body></body>";
            WysiwygController.createUnindexedFileAndAttachment((String)basicTemplate, (ResourceReference)new ResourceReference("template" + letterPK.getId(), componentId), (String)userId, (String)I18NHelper.DEFAULT_LANGUAGE);
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
    }

    private Connection openConnection() {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
        return con;
    }

    @Override
    public Set<String> sendTemplateByMail(InfoLetter il, String mimeMultipart, Set<String> listEmailDest, String subject, String emailFrom) {
        return this.sendContributionByMail(il.getTemplateIdentifier(), mimeMultipart, listEmailDest, subject, emailFrom);
    }

    @Override
    public Set<String> sendLetterByMail(InfoLetterPublicationPdC ilp, String mimeMultipart, Set<String> listEmailDest, String subject, String emailFrom) {
        return this.sendContributionByMail(ilp.getIdentifier(), mimeMultipart, listEmailDest, subject, emailFrom);
    }

    private Set<String> sendContributionByMail(ContributionIdentifier cId, String mimeMultipart, Set<String> listEmailDest, String subject, String emailFrom) {
        HashSet<String> emailErrors = new HashSet<String>();
        HashSet emailDest = new HashSet();
        listEmailDest.forEach(m -> {
            try {
                new InternetAddress(m);
                emailDest.add(m);
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error((Throwable)ex);
                emailErrors.add((String)m);
            }
        });
        if (!emailDest.isEmpty()) {
            try {
                ResourceReference foreignKey = cId.toReference();
                SimpleDocumentList listAttachedFiles = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.attachment, null);
                String wysiwygContent = WysiwygController.load((String)foreignKey.getInstanceId(), (String)foreignKey.getId(), null);
                WysiwygContentTransformer.on((String)wysiwygContent).toMailContent().withMimeMultipart(mimeMultipart).addAttachments((Collection)listAttachedFiles).prepareMailSendingFrom(MailAddress.eMail((String)emailFrom)).to(ReceiverMailAddressSet.with((Collection)listEmailDest.stream().map(MailAddress::eMail).collect(Collectors.toSet()))).withSubject(subject).oneMailPerReceiver().send();
            }
            catch (Exception e) {
                throw new InfoLetterException(e);
            }
        }
        return emailErrors;
    }

    @Override
    public void indexInfoLetter(String componentId) {
        InfoLetter infoLetter = this.getInfoLetters(componentId).get(0);
        this.createIndex(infoLetter);
        this.indexPublications(infoLetter);
    }

    private void indexPublications(InfoLetter infoLetter) {
        try {
            Optional.ofNullable(this.getInfoLetterPublications(infoLetter.getPK())).stream().flatMap(Collection::stream).forEach(this::processPublicationIndexation);
        }
        catch (Exception e) {
            throw new InfoLetterException(e);
        }
    }

    private void processPublicationIndexation(InfoLetterPublication pub) {
        try {
            if (pub.isValid()) {
                this.createIndex(pub);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Error during indexation of newsletter {0}", new Object[]{pub.getPK().getId(), e});
        }
    }

    private void createIndex(InfoLetter il) {
        if (il != null) {
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(il.getInstanceId(), "Lettre", il.getPK().getId()));
            indexEntry.setTitle(il.getName());
            indexEntry.setPreview(il.getDescription());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void deleteIndex(InfoLetter il) {
        IndexEntryKey indexEntry = new IndexEntryKey(il.getInstanceId(), "Lettre", il.getPK().getId());
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }

    private void createIndex(InfoLetterPublication pub) {
        if (pub != null) {
            ContributionIdentifier identifier = pub.getIdentifier();
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(identifier.getComponentInstanceId(), "publication", identifier.getLocalId()));
            indexEntry.setTitle(pub.getTitle());
            indexEntry.setPreview(pub.getDescription());
            try {
                indexEntry.setCreationDate(DateUtil.parse((String)pub.getParutionDate()));
            }
            catch (ParseException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
            indexEntry.setCreationUser(User.getCurrentUser().getId());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void deleteIndex(InfoLetterPublication pub) {
        ContributionIdentifier identifier = pub.getIdentifier();
        IndexEntryKey indexEntry = new IndexEntryKey(identifier.getComponentInstanceId(), "publication", identifier.getLocalId());
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }
}

