/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.jetbrains.annotations.NotNull;

public final class GroupPrincipals {
    private GroupPrincipals() {
    }

    public static boolean isGroup(@NotNull Principal principal) {
        return principal instanceof GroupPrincipal;
    }

    @NotNull
    public static Enumeration<? extends Principal> members(@NotNull Principal principal) {
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).members();
        }
        return Collections.emptyEnumeration();
    }

    public static boolean isMember(@NotNull Principal principal, @NotNull Principal member) {
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).isMember(member);
        }
        return false;
    }
}

