/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

final class PrivilegeContext
implements Context,
PrivilegeConstants {
    private static final Context INSTANCE = new PrivilegeContext();

    private PrivilegeContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return PRIVILEGE_PROPERTY_NAMES.contains(property.getName()) && this.definesTree(parent);
    }

    public boolean definesContextRoot(@NotNull Tree tree) {
        return "rep:privileges".equals(tree.getName()) && "rep:Privileges".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public boolean definesTree(@NotNull Tree tree) {
        return PRIVILEGE_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public boolean definesLocation(@NotNull TreeLocation location) {
        return Text.isDescendantOrEqual((String)"/jcr:system/rep:privileges", (String)location.getPath());
    }

    public boolean definesInternal(@NotNull Tree tree) {
        return false;
    }
}

