/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.split.DefaultSplitBlobStore;
import org.apache.jackrabbit.oak.spi.blob.split.SplitBlobStore;
import org.apache.jackrabbit.oak.spi.blob.split.WrappingSplitBlobStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
public class SplitBlobStoreService {
    private static final Logger log = LoggerFactory.getLogger(SplitBlobStoreService.class);
    @Property
    private static final String PROP_HOME = "repository.home";
    @Property(options={@PropertyOption(name="External", value="EXTERNAL"), @PropertyOption(name="Internal - Segment", value="SEGMENT"), @PropertyOption(name="Internal - Document", value="DOCUMENT")})
    private static final String PROP_OLD_BLOB_STORE_TYPE = "split.old.blobstore.type";
    public static final String PROP_SPLIT_BLOBSTORE = "split.blobstore";
    public static final String ONLY_STANDALONE_TARGET = "(&(!(split.blobstore=old))(!(split.blobstore=new)))";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(split.blobstore=old)")
    private BlobStore oldBlobStore;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(split.blobstore=new)")
    private BlobStore newBlobStore;
    private BundleContext ctx;
    private ServiceRegistration reg;
    private String homeDir;
    private BlobStoreType oldBlobStoreType;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) throws InvalidSyntaxException {
        String oldTypeName = SplitBlobStoreService.lookup(context, PROP_OLD_BLOB_STORE_TYPE);
        this.oldBlobStoreType = oldTypeName == null ? BlobStoreType.EXTERNAL : BlobStoreType.valueOf(oldTypeName);
        this.homeDir = SplitBlobStoreService.lookup(context, PROP_HOME);
        if (this.homeDir == null) {
            log.warn("Can't initialize SplitBlobStore - empty {}", (Object)PROP_HOME);
            return;
        }
        log.info("Initializing the SplitBlobStore with home [{}]", (Object)this.homeDir);
        this.ctx = context.getBundleContext();
        this.registerSplitBlobStore();
    }

    @Deactivate
    protected void deactivate() {
        this.unregisterSplitBlobStore();
        this.ctx = null;
    }

    private void registerSplitBlobStore() {
        SplitBlobStore blobStore;
        if (this.oldBlobStore == null && this.oldBlobStoreType == BlobStoreType.EXTERNAL) {
            log.info("No BlobStore with ({}=old)", (Object)PROP_SPLIT_BLOBSTORE);
            return;
        }
        if (this.newBlobStore == null) {
            log.info("No BlobStore with ({}=new)", (Object)PROP_SPLIT_BLOBSTORE);
            return;
        }
        if (this.reg != null) {
            log.info("SplitBlobStore already registered");
            return;
        }
        if (this.ctx == null) {
            log.info("Component not activated yet");
            return;
        }
        log.info("Registering SplitBlobStore with old={} ({}) and new={}", new Object[]{this.oldBlobStore, this.oldBlobStoreType, this.newBlobStore});
        if (this.oldBlobStoreType == BlobStoreType.EXTERNAL || this.oldBlobStoreType == BlobStoreType.SEGMENT) {
            blobStore = new DefaultSplitBlobStore(this.homeDir, this.oldBlobStore, this.newBlobStore);
        } else if (this.oldBlobStoreType == BlobStoreType.DOCUMENT) {
            blobStore = new WrappingSplitBlobStore(this.homeDir, this.newBlobStore);
        } else {
            throw new IllegalStateException("Illegal blob store type value: " + this.oldBlobStoreType);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.apache.jackrabbit.oak.spi.blob.split.SplitBlobStore");
        this.reg = this.ctx.registerService(new String[]{BlobStore.class.getName()}, (Object)blobStore, props);
    }

    private void unregisterSplitBlobStore() {
        if (this.reg != null) {
            this.reg.unregister();
        }
        this.reg = null;
    }

    private static String lookup(ComponentContext context, String property) {
        if (context.getBundleContext().getProperty(property) != null) {
            return context.getBundleContext().getProperty(property);
        }
        if (context.getProperties().get(property) != null) {
            return context.getProperties().get(property).toString();
        }
        return null;
    }

    protected void bindOldBlobStore(BlobStore blobStore) {
        this.oldBlobStore = blobStore;
        this.registerSplitBlobStore();
    }

    protected void unbindOldBlobStore(BlobStore blobStore) {
        this.oldBlobStore = null;
        this.unregisterSplitBlobStore();
    }

    protected void bindNewBlobStore(BlobStore blobStore) {
        this.newBlobStore = blobStore;
        this.registerSplitBlobStore();
    }

    protected void unbindNewBlobStore(BlobStore blobStore) {
        this.newBlobStore = null;
        this.unregisterSplitBlobStore();
    }

    static enum BlobStoreType {
        EXTERNAL,
        DOCUMENT,
        SEGMENT;

    }
}

