/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.webpages.notification;

import java.lang.annotation.Annotation;
import java.util.List;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;

abstract class AbstractWebPagesNotification
extends AbstractTemplateUserNotificationBuilder<NodePK> {
    private final User user;
    private final String pageName;

    public AbstractWebPagesNotification(NodePK resource, User user) {
        super((Object)resource);
        this.user = user;
        this.pageName = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(this.getComponentInstanceId()).getLabel();
    }

    protected void performTemplateData(String language, NodePK resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("path", (Object)"");
        template.setAttribute("senderName", (Object)this.user.getDisplayedName());
        template.setAttribute("pageName", (Object)Encode.forHtml((String)this.pageName));
    }

    protected void performNotificationResource(String language, NodePK resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(this.pageName);
        notificationResourceData.setResourceId(resource.getId());
        notificationResourceData.setResourceType(this.getTemplatePath());
        notificationResourceData.setResourceLocation(this.buildResourceLocation());
    }

    private String buildResourceLocation() {
        StringBuilder sb = new StringBuilder();
        AdminController adminController = (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
        List spaces = adminController.getPathToComponent(this.getComponentInstanceId());
        for (SpaceInstLight space : spaces) {
            if (sb.length() > 0) {
                sb.append("@#@#@");
            }
            sb.append(space.getName());
        }
        return sb.toString();
    }

    protected String getResourceURL(NodePK resource) {
        return URLUtil.getURL(null, null, (String)resource.getInstanceId()) + "Main";
    }

    protected String getSender() {
        return this.user.getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.webpages.multilang.webPagesBundle";
    }

    protected String getTemplatePath() {
        return "webpages";
    }

    protected String getComponentInstanceId() {
        return ((NodePK)this.getResource()).getInstanceId();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "webPages.notifWebPageLinkLabel";
    }
}

