/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.exceptions.mappers;

import edu.psu.swe.commons.jaxrs.ErrorMessage;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageViolationExceptionMapper
implements ExceptionMapper<ResteasyViolationException> {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageViolationExceptionMapper.class);

    public Response toResponse(ResteasyViolationException resteasyViolationException) {
        ErrorMessage em = new ErrorMessage();
        Exception e = resteasyViolationException.getException();
        List violations = resteasyViolationException.getViolations();
        violations.stream().map(ResteasyConstraintViolation::toString).forEach(arg_0 -> ((Logger)log).info(arg_0));
        if (e != null) {
            em.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            em.addErrorMessage(e.toString());
        } else if (resteasyViolationException.getReturnValueViolations().isEmpty()) {
            em.setStatus(Response.Status.BAD_REQUEST);
            em.setErrorMessageList(this.extractMessages(violations));
        } else {
            em.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            em.setErrorMessageList(this.extractMessages(violations));
        }
        return em.toResponse();
    }

    private List<String> extractMessages(List<ResteasyConstraintViolation> violations) {
        return violations.stream().map(rcv -> "Constraint Violation: " + rcv.getConstraintType().name() + "[" + rcv.getPath() + " = '" + rcv.getValue() + "']: " + rcv.getMessage()).collect(Collectors.toList());
    }
}

