/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.silverpeas.components.kmelia.KmeliaCopyDetail;
import org.silverpeas.components.kmelia.KmeliaPasteDetail;
import org.silverpeas.components.kmelia.model.KmeliaPublication;
import org.silverpeas.components.kmelia.model.TopicDetail;
import org.silverpeas.components.kmelia.model.ValidatorsList;
import org.silverpeas.core.ApplicationService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.silverstatistics.access.model.HistoryObjectDetail;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.util.Pair;

public interface KmeliaService
extends ApplicationService {
    public static KmeliaService get() {
        return (KmeliaService)ServiceProvider.getService(KmeliaService.class, (Annotation[])new Annotation[0]);
    }

    public Optional<KmeliaPublication> getContributionById(ContributionIdentifier var1);

    public TopicDetail goTo(NodePK var1, String var2, boolean var3, String var4, boolean var5);

    public List<NodeDetail> getAllowedSubfolders(NodeDetail var1, String var2);

    public NodeDetail addToTopic(NodePK var1, NodeDetail var2);

    public NodeDetail addSubTopic(NodePK var1, NodeDetail var2, String var3);

    public NodeDetail updateTopic(NodeDetail var1, String var2);

    public NodeDetail getSubTopicDetail(NodePK var1);

    public void changeTopicStatus(String var1, NodePK var2, boolean var3);

    public void sortSubTopics(NodePK var1, boolean var2, String[] var3);

    public List<NodeDetail> getTreeview(NodePK var1, String var2, boolean var3, boolean var4, String var5, boolean var6, boolean var7);

    public PublicationDetail getPublicationDetail(PublicationPK var1);

    public List<KmeliaPublication> getAuthorizedPublicationsOfFolder(NodePK var1, String var2, String var3, boolean var4);

    public List<KmeliaPublication> getLatestAuthorizedPublications(String var1, String var2, int var3);

    public Collection<Collection<NodeDetail>> getPathList(PublicationPK var1);

    public NodePK getPublicationFatherPK(PublicationPK var1);

    public String createPublicationIntoTopic(PublicationDetail var1, NodePK var2);

    public String createPublicationIntoTopic(PublicationDetail var1, NodePK var2, PdcClassification var3);

    public void updatePublication(PublicationDetail var1);

    public void updatePublication(PublicationDetail var1, PdcClassification var2);

    public void updatePublication(PublicationDetail var1, boolean var2);

    public void addPublicationToTopic(PublicationPK var1, NodePK var2, boolean var3);

    public void addPublicationToTopicWithoutNotifications(PublicationPK var1, NodePK var2, boolean var3);

    public void addInfoLinks(PublicationPK var1, List<ResourceReference> var2);

    public CompletePublication getCompletePublication(PublicationPK var1);

    public KmeliaPublication getPublication(PublicationPK var1, NodePK var2);

    public TopicDetail getBestTopicDetailOfPublicationForUser(PublicationPK var1, boolean var2, String var3);

    public NodePK getBestLocationOfPublicationForUser(PublicationPK var1, String var2);

    public <T extends ResourceReference> List<PublicationDetail> getPublicationDetails(List<T> var1);

    public <T extends ResourceReference> List<KmeliaPublication> getPublications(List<T> var1, String var2, NodePK var3, boolean var4);

    public <T extends ResourceReference> List<Pair<KmeliaPublication, KmeliaPublication>> getPublicationsForModification(List<T> var1, String var2);

    public List<KmeliaPublication> getLinkedPublications(KmeliaPublication var1, String var2);

    public List<KmeliaPublication> getPublicationsToValidate(String var1, String var2);

    public boolean isUserCanValidatePublication(PublicationPK var1, String var2);

    public ValidatorsList getAllValidators(PublicationPK var1);

    public void setValidators(PublicationPK var1, String var2);

    public boolean validatePublication(PublicationPK var1, String var2, boolean var3, boolean var4);

    public void unvalidatePublication(PublicationPK var1, String var2, String var3, int var4);

    public void suspendPublication(PublicationPK var1, String var2, String var3);

    public void draftOutPublication(PublicationPK var1, NodePK var2, String var3);

    public PublicationDetail draftOutPublicationWithoutNotifications(PublicationPK var1, NodePK var2, String var3);

    public void draftOutPublication(PublicationPK var1, NodePK var2, String var3, boolean var4);

    public void draftInPublication(PublicationPK var1);

    public void draftInPublication(PublicationPK var1, String var2);

    public void movePublication(PublicationPK var1, NodePK var2, KmeliaPasteDetail var3);

    public void movePublicationInSameApplication(PublicationPK var1, NodePK var2, KmeliaPasteDetail var3);

    public void externalElementsOfPublicationHaveChanged(PublicationPK var1, String var2);

    public void sendModificationAlert(int var1, PublicationPK var2);

    public UserNotification getUserNotification(PublicationPK var1, NodePK var2);

    public UserNotification getUserNotification(PublicationPK var1, SimpleDocumentPK var2, NodePK var3);

    public UserNotification getUserNotification(NodePK var1);

    public void deleteAllReadingControlsByPublication(PublicationPK var1);

    public void indexKmelia(String var1);

    public int getSilverObjectId(PublicationPK var1);

    public void deleteSilverContent(PublicationPK var1);

    public void setModelUsed(String[] var1, String var2, String var3);

    public Collection<String> getModelUsed(String var1, String var2);

    public List<NodeDetail> getAxis(String var1);

    public List<NodeDetail> getAxisHeaders(String var1);

    public NodePK addAxis(NodeDetail var1, String var2);

    public void updateAxis(NodeDetail var1, String var2);

    public void deleteAxis(String var1, String var2);

    public NodeDetail getNodeHeader(String var1, String var2);

    public void addPosition(String var1, NodeDetail var2, String var3, String var4);

    public void updatePosition(NodeDetail var1, String var2);

    public void deletePosition(String var1, String var2);

    public Collection<NodeDetail> getPath(String var1, String var2);

    public List<KmeliaPublication> search(List<String> var1, String var2);

    public List<KmeliaPublication> search(List<String> var1, int var2, String var3);

    public Collection<KmeliaPublication> getUnbalancedPublications(String var1);

    public void indexKmax(String var1);

    public KmeliaPublication getKmaxPublication(String var1, String var2);

    public Collection<Coordinate> getPublicationCoordinates(String var1, String var2);

    public void addPublicationToCombination(String var1, List<String> var2, String var3);

    public void deletePublicationFromCombination(String var1, String var2, String var3);

    public String createKmaxPublication(PublicationDetail var1);

    public Collection<Location> getLocations(PublicationPK var1);

    public Collection<Location> getAliases(PublicationPK var1);

    public void setAliases(PublicationPK var1, List<Location> var2);

    public void addAttachmentToPublication(PublicationPK var1, String var2, String var3, String var4, byte[] var5);

    public NodeDetail createTopic(String var1, String var2, String var3, String var4, String var5, String var6);

    public String clonePublication(CompletePublication var1, PublicationDetail var2, String var3);

    public void removeContentOfPublication(PublicationPK var1);

    public NodeDetail getRoot(String var1, String var2);

    public Collection<NodeDetail> getFolderChildren(NodePK var1, String var2);

    public NodeDetail getFolder(NodePK var1, String var2);

    public NodeDetail getExpandedPathToNode(NodePK var1, String var2);

    public boolean isUserCanWrite(String var1, String var2);

    public boolean isUserCanValidate(String var1, String var2);

    public boolean isUserCanPublish(String var1, String var2);

    public String getUserTopicProfile(NodePK var1, String var2);

    public List<String> deletePublications(List<String> var1, NodePK var2, String var3);

    public void deletePublication(PublicationPK var1, String var2);

    public void deleteTopic(@NonNull NodePK var1, String var2);

    public List<String> getUserIdsOfFolder(NodePK var1);

    public List<HistoryObjectDetail> getLastAccess(PublicationPK var1, NodePK var2, String var3, int var4);

    public NodeDetail copyNode(KmeliaCopyDetail var1);

    public void copyPublications(KmeliaCopyDetail var1);

    public PublicationDetail copyPublication(PublicationDetail var1, KmeliaCopyDetail var2);

    public void moveNode(NodePK var1, NodePK var2, KmeliaPasteDetail var3);

    public List<KmeliaPublication> filterPublications(List<KmeliaPublication> var1, String var2, SilverpeasRole var3, String var4);

    public void userHaveBeenDeleted(String var1);

    public List<String> getActiveValidatorIds(PublicationPK var1);

    public void performReminder(Reminder var1);

    public void deleteClone(PublicationPK var1);

    public List<KmeliaPublication> getNonVisiblePublications(String var1, String var2);
}

