/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InheritedMembersIterator
extends AbstractLazyIterator<Authorizable> {
    private static final Logger log = LoggerFactory.getLogger(InheritedMembersIterator.class);
    private final Iterator<Authorizable> members;
    private final DynamicMembershipProvider dynamicMembershipProvider;
    private final List<Group> groups = new ArrayList<Group>();
    private Iterator<Authorizable> dynamicMembers;

    InheritedMembersIterator(@NotNull Iterator<Authorizable> members, @NotNull DynamicMembershipProvider dynamicMembershipProvider) {
        this.members = members;
        this.dynamicMembershipProvider = dynamicMembershipProvider;
    }

    protected Authorizable getNext() {
        if (this.members.hasNext()) {
            Authorizable member = this.members.next();
            if (member.isGroup()) {
                this.rememberGroup((Group)member);
            }
            return member;
        }
        if (this.dynamicMembers == null || !this.dynamicMembers.hasNext()) {
            this.dynamicMembers = this.getNextDynamicMembersIterator();
        }
        if (this.dynamicMembers.hasNext()) {
            return this.dynamicMembers.next();
        }
        return null;
    }

    private void rememberGroup(@NotNull Group group) {
        this.groups.add(group);
    }

    @NotNull
    private Iterator<Authorizable> getNextDynamicMembersIterator() {
        while (!this.groups.isEmpty()) {
            Group group = this.groups.remove(0);
            try {
                Iterator it = this.dynamicMembershipProvider.getMembers(group, false);
                if (!it.hasNext()) continue;
                return it;
            }
            catch (RepositoryException e) {
                log.error("Failed to retrieve dynamic members of group '{}'", (Object)Utils.getIdOrNull((Authorizable)group), (Object)e);
            }
        }
        return Collections.emptyIterator();
    }
}

