/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.CachingSegmentReader;
import org.apache.jackrabbit.oak.segment.RecordType;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentBufferMonitor;
import org.apache.jackrabbit.oak.segment.SegmentCache;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdFactory;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.data.SegmentData;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.ManifestChecker;
import org.apache.jackrabbit.oak.segment.file.tar.EntryRecovery;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.apache.jackrabbit.oak.segment.file.tar.TarRecovery;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileStore
implements SegmentStore,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileStore.class);
    private static final int MIN_STORE_VERSION = 1;
    private static final int MAX_STORE_VERSION = 2;
    @NotNull
    final SegmentTracker tracker;
    @NotNull
    final CachingSegmentReader segmentReader;
    final File directory;
    private final BlobStore blobStore;
    final boolean memoryMapping;
    final boolean offHeapAccess;
    @NotNull
    final SegmentCache segmentCache;
    final TarRecovery recovery = new TarRecovery(){

        @Override
        public void recoverEntry(UUID uuid, byte[] data, EntryRecovery entryRecovery) throws IOException {
            AbstractFileStore.this.writeSegment(uuid, data, entryRecovery);
        }
    };
    @NotNull
    private final SegmentBufferMonitor segmentBufferMonitor;
    protected final IOMonitor ioMonitor;
    protected final RemoteStoreMonitor remoteStoreMonitor;
    protected final int binariesInlineThreshold;

    static ManifestChecker newManifestChecker(SegmentNodeStorePersistence persistence, boolean strictVersionCheck) throws IOException {
        return ManifestChecker.newManifestChecker(persistence.getManifestFile(), persistence.segmentFilesExist(), strictVersionCheck ? 2 : 1, 2);
    }

    AbstractFileStore(FileStoreBuilder builder) {
        this.directory = builder.getDirectory();
        this.tracker = new SegmentTracker(new SegmentIdFactory(){

            @Override
            @NotNull
            public SegmentId newSegmentId(long msb, long lsb) {
                return new SegmentId(AbstractFileStore.this, msb, lsb, AbstractFileStore.this.segmentCache::recordHit);
            }
        });
        this.blobStore = builder.getBlobStore();
        this.segmentCache = SegmentCache.newSegmentCache(builder.getSegmentCacheSize());
        this.segmentReader = new CachingSegmentReader((Supplier<SegmentWriter>)((Supplier)this::getWriter), this.blobStore, builder.getStringCacheSize(), builder.getTemplateCacheSize(), builder.getStatsProvider().getMeter("oak.segment.reads", StatsOptions.DEFAULT));
        this.memoryMapping = builder.getMemoryMapping();
        this.offHeapAccess = builder.getOffHeapAccess();
        this.ioMonitor = builder.getIOMonitor();
        this.remoteStoreMonitor = builder.getRemoteStoreMonitor();
        this.segmentBufferMonitor = new SegmentBufferMonitor(builder.getStatsProvider());
        this.binariesInlineThreshold = builder.getBinariesInlineThreshold();
    }

    static SegmentNotFoundException asSegmentNotFoundException(Exception e, SegmentId id) {
        if (e.getCause() instanceof SegmentNotFoundException) {
            return (SegmentNotFoundException)((Object)e.getCause());
        }
        return new SegmentNotFoundException(id, e);
    }

    @NotNull
    public CacheStatsMBean getSegmentCacheStats() {
        return this.segmentCache.getCacheStats();
    }

    @NotNull
    public CacheStatsMBean getStringCacheStats() {
        return this.segmentReader.getStringCacheStats();
    }

    @NotNull
    public CacheStatsMBean getTemplateCacheStats() {
        return this.segmentReader.getTemplateCacheStats();
    }

    @NotNull
    public abstract SegmentWriter getWriter();

    @NotNull
    public SegmentReader getReader() {
        return this.segmentReader;
    }

    @NotNull
    public SegmentIdProvider getSegmentIdProvider() {
        return this.tracker;
    }

    public int getBinariesInlineThreshold() {
        return this.binariesInlineThreshold;
    }

    public abstract Revisions getRevisions();

    @NotNull
    public SegmentNodeState getHead() {
        return this.segmentReader.readHeadState(this.getRevisions());
    }

    @Nullable
    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    private void writeSegment(UUID id, byte[] data, EntryRecovery w) throws IOException {
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        Buffer buffer = Buffer.wrap((byte[])data);
        GCGeneration generation = SegmentId.isDataSegmentId(lsb) ? Segment.getGcGeneration(SegmentData.newSegmentData(buffer), id) : GCGeneration.NULL;
        w.recoverEntry(msb, lsb, data, 0, data.length, generation);
        if (SegmentId.isDataSegmentId(lsb)) {
            Segment segment = new Segment(this.tracker, this.segmentReader, this.tracker.newSegmentId(msb, lsb), buffer);
            AbstractFileStore.populateTarGraph(segment, w);
            AbstractFileStore.populateTarBinaryReferences(segment, w);
        }
    }

    private static void populateTarGraph(Segment segment, EntryRecovery w) {
        UUID from = segment.getSegmentId().asUUID();
        for (int i = 0; i < segment.getReferencedSegmentIdCount(); ++i) {
            w.recoverGraphEdge(from, segment.getReferencedSegmentId(i));
        }
    }

    private static void populateTarBinaryReferences(Segment segment, EntryRecovery w) {
        GCGeneration generation = segment.getGcGeneration();
        UUID id = segment.getSegmentId().asUUID();
        segment.forEachRecord((number, type, offset) -> {
            if (type == RecordType.BLOB_ID) {
                w.recoverBinaryReference(generation, id, SegmentBlob.readBlobId(segment, number));
            }
        });
    }

    static Set<UUID> readReferences(Segment segment) {
        HashSet<UUID> references = new HashSet<UUID>();
        for (int i = 0; i < segment.getReferencedSegmentIdCount(); ++i) {
            references.add(segment.getReferencedSegmentId(i));
        }
        return references;
    }

    static Set<String> readBinaryReferences(final Segment segment) {
        final HashSet<String> binaryReferences = new HashSet<String>();
        segment.forEachRecord(new Segment.RecordConsumer(){

            @Override
            public void consume(int number, RecordType type, int offset) {
                if (type == RecordType.BLOB_ID) {
                    binaryReferences.add(SegmentBlob.readBlobId(segment, number));
                }
            }
        });
        return binaryReferences;
    }

    static void closeAndLogOnFail(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    Segment readSegmentUncached(TarFiles tarFiles, SegmentId id) {
        Buffer buffer = tarFiles.readSegment(id.getMostSignificantBits(), id.getLeastSignificantBits());
        if (buffer == null) {
            throw new SegmentNotFoundException(id);
        }
        this.segmentBufferMonitor.trackAllocation(buffer);
        return new Segment(this.tracker, this.segmentReader, id, buffer);
    }

    public abstract void collectBlobReferences(Consumer<String> var1) throws IOException;
}

