/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoQueryException;
import com.mongodb.ReadConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.plugins.document.mongo.ReplicaSetStatus;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStatus
implements ServerMonitorListener {
    private static final Logger LOG = LoggerFactory.getLogger(MongoStatus.class);
    private static final ImmutableSet<String> SERVER_DETAIL_FIELD_NAMES = ImmutableSet.builder().add((Object[])new String[]{"host", "process", "connections", "repl", "storageEngine", "mem"}).build();
    private final MongoClient client;
    private final String dbName;
    private BasicDBObject serverStatus;
    private BasicDBObject buildInfo;
    private String version;
    private Boolean majorityReadConcernSupported;
    private Boolean majorityReadConcernEnabled;
    private Boolean clientSessionSupported;
    private final ReplicaSetStatus replicaSetStatus = new ReplicaSetStatus();

    public MongoStatus(@NotNull MongoClient client, @NotNull String dbName) {
        this.client = client;
        this.dbName = dbName;
    }

    public void checkVersion() {
        if (!this.isVersion(2, 6)) {
            String msg = "MongoDB version 2.6.0 or higher required. Currently connected to a MongoDB with version: " + this.version;
            throw new RuntimeException(msg);
        }
    }

    public boolean isMajorityReadConcernSupported() {
        if (this.majorityReadConcernSupported == null) {
            BasicDBObject stat = this.getServerStatus();
            if (stat.isEmpty()) {
                LOG.debug("User doesn't have privileges to get server status; falling back to the isMajorityReadConcernEnabled()");
                return this.isMajorityReadConcernEnabled();
            }
            if (stat.containsField("storageEngine")) {
                BasicDBObject storageEngine = (BasicDBObject)stat.get("storageEngine");
                this.majorityReadConcernSupported = storageEngine.getBoolean("supportsCommittedReads");
            } else {
                this.majorityReadConcernSupported = false;
            }
        }
        return this.majorityReadConcernSupported;
    }

    public boolean isMajorityReadConcernEnabled() {
        if (this.majorityReadConcernEnabled == null) {
            MongoCollection emptyCollection = this.client.getDatabase(this.dbName).getCollection("emptyCollection-" + System.currentTimeMillis());
            try (MongoCursor cursor = emptyCollection.withReadConcern(ReadConcern.MAJORITY).find((Bson)new BasicDBObject()).iterator();){
                cursor.hasNext();
                this.majorityReadConcernEnabled = true;
            }
            catch (MongoQueryException | IllegalArgumentException e) {
                this.majorityReadConcernEnabled = false;
            }
        }
        return this.majorityReadConcernEnabled;
    }

    @NotNull
    public String getServerDetails() {
        HashMap details = Maps.newHashMap();
        for (String key : SERVER_DETAIL_FIELD_NAMES) {
            Object value = this.getServerStatus().get(key);
            if (value == null) continue;
            details.put(key, value);
        }
        return ((Object)details).toString();
    }

    @NotNull
    public String getVersion() {
        if (this.version == null) {
            String v = this.getServerStatus().getString("version");
            if (v == null) {
                v = this.getBuildInfo().getString("version");
            }
            this.version = v;
        }
        return this.version;
    }

    boolean isVersion(int requiredMajor, int requiredMinor) {
        String v = this.getVersion();
        Matcher m = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(v);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed MongoDB version: " + v);
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        if (major > requiredMajor) {
            return true;
        }
        if (major == requiredMajor) {
            return minor >= requiredMinor;
        }
        return false;
    }

    boolean isClientSessionSupported() {
        if (this.clientSessionSupported == null) {
            if (this.isVersion(3, 6)) {
                ClientSessionOptions options = ClientSessionOptions.builder().causallyConsistent(true).build();
                try (ClientSession ignored = this.client.startSession(options);){
                    this.clientSessionSupported = true;
                }
                catch (MongoClientException e) {
                    this.clientSessionSupported = false;
                }
            } else {
                this.clientSessionSupported = false;
            }
        }
        return this.clientSessionSupported;
    }

    long getReplicaSetLagEstimate() {
        return this.replicaSetStatus.getLagEstimate();
    }

    public void serverHearbeatStarted(ServerHeartbeatStartedEvent event) {
        LOG.debug("serverHeartbeatStarted {}", (Object)event.getConnectionId());
        this.replicaSetStatus.serverHearbeatStarted(event);
    }

    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent event) {
        LOG.debug("serverHeartbeatSucceeded {}, {}", (Object)event.getConnectionId(), (Object)event.getReply());
        this.replicaSetStatus.serverHeartbeatSucceeded(event);
    }

    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent event) {
        LOG.debug("serverHeartbeatFailed {} ({} ms)", new Object[]{event.getConnectionId(), event.getElapsedTime(TimeUnit.MILLISECONDS), event.getThrowable()});
        this.replicaSetStatus.serverHeartbeatFailed(event);
    }

    private BasicDBObject getServerStatus() {
        if (this.serverStatus == null) {
            try {
                this.serverStatus = (BasicDBObject)this.client.getDatabase(this.dbName).runCommand((Bson)new BasicDBObject("serverStatus", (Object)1), BasicDBObject.class);
            }
            catch (MongoCommandException e) {
                if (e.getErrorCode() == -1) {
                    this.serverStatus = new BasicDBObject();
                }
                if (e.getErrorCode() == 13) {
                    this.serverStatus = new BasicDBObject();
                }
                throw e;
            }
        }
        return this.serverStatus;
    }

    private BasicDBObject getBuildInfo() {
        if (this.buildInfo == null) {
            this.buildInfo = (BasicDBObject)this.client.getDatabase(this.dbName).runCommand((Bson)new BasicDBObject("buildInfo", (Object)1), BasicDBObject.class);
        }
        return this.buildInfo;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setServerStatus(BasicDBObject serverStatus) {
        this.majorityReadConcernSupported = null;
        this.serverStatus = serverStatus;
    }
}

