/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.rs;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.service.UserProvider;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.Authentication;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.web.rs.AuthenticationScheme;
import org.silverpeas.core.web.token.SynchronizerTokenService;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class HTTPAuthentication {
    private static final Pattern AUTHORIZATION_PATTERN = Pattern.compile("(?i)^(Basic|Bearer) (.*)");
    private static final Pattern AUTHENTICATION_PATTERN = Pattern.compile("(?i)^\\s*(\\S+)\\s*@domain([0-9]+):(.+)$");
    private static final Map<AuthenticationScheme, Function<AuthenticationContext, SessionInfo>> schemeHandlers = new EnumMap<AuthenticationScheme, Function<AuthenticationContext, SessionInfo>>(AuthenticationScheme.class);

    protected HTTPAuthentication() {
    }

    public SessionInfo authenticate(AuthenticationContext context) {
        try {
            Mutable session = Mutable.empty();
            String authorizationValue = context.getHttpServletRequest().getHeader("Authorization");
            if (StringUtil.isDefined((String)authorizationValue)) {
                Matcher authorizationMatcher = AUTHORIZATION_PATTERN.matcher(authorizationValue);
                int authorizationValuePartCount = 2;
                boolean schemePart = true;
                int credentialsPart = 2;
                if (!authorizationMatcher.matches() || authorizationMatcher.groupCount() != 2) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
                Optional<AuthenticationScheme> credentialType = AuthenticationScheme.from(authorizationMatcher.group(1));
                String userCredentials = authorizationMatcher.group(2);
                credentialType.ifPresent(scheme -> {
                    context.setAuthenticationScheme((AuthenticationScheme)((Object)scheme));
                    context.setUserCredentials(userCredentials);
                    session.set((Object)schemeHandlers.get(scheme).apply(context));
                });
            } else {
                authorizationValue = context.getHttpServletRequest().getParameter("access_token");
                if (StringUtil.isDefined((String)authorizationValue)) {
                    context.setAuthenticationScheme(AuthenticationScheme.BEARER);
                    context.setUserCredentials(authorizationValue);
                    session.set((Object)schemeHandlers.get((Object)AuthenticationScheme.BEARER).apply(context));
                }
            }
            return (SessionInfo)session.orElseThrow(() -> new WebApplicationException(Response.Status.UNAUTHORIZED));
        }
        catch (AuthenticationInternalException ex) {
            throw new WebApplicationException((Throwable)((Object)ex), Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private static SessionInfo performBasicAuthentication(AuthenticationContext context) {
        String decodedCredentials = new String(StringUtil.fromBase64((String)context.getUserCredentials()), Charsets.UTF_8).trim();
        Matcher matcher = AUTHENTICATION_PATTERN.matcher(decodedCredentials);
        int credentialPartCount = 3;
        boolean loginPart = true;
        int passwordPart = 3;
        int domainIdPart = 2;
        if (matcher.matches() && matcher.groupCount() == 3) {
            try {
                AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)matcher.group(1)).withAsPassword(matcher.group(3)).withAsDomainId(matcher.group(2));
                Authentication authenticator = Authentication.get();
                AuthenticationResponse result = authenticator.authenticate(credential);
                if (result.getStatus().succeeded()) {
                    SessionInfo session;
                    User user = authenticator.getUserByAuthToken(result.getToken());
                    if (!user.isAnonymous()) {
                        session = SessionManagementProvider.getSessionManagement().openSession(user, context.getHttpServletRequest());
                        context.getHttpServletResponse().setHeader("X-Silverpeas-Session", session.getSessionId());
                        context.getHttpServletResponse().addHeader("Access-Control-Expose-Headers", "X-Silverpeas-Session");
                        SynchronizerTokenService tokenService = SynchronizerTokenService.getInstance();
                        tokenService.setUpSessionTokens(session);
                        Token token = tokenService.getSessionToken(session);
                        context.getHttpServletResponse().addHeader("X-STKN", token.getValue());
                    } else {
                        session = SessionManagementProvider.getSessionManagement().openAnonymousSession(context.getHttpServletRequest());
                    }
                    return session;
                }
            }
            catch (AuthenticationException e) {
                throw new AuthenticationInternalException(e.getMessage(), e);
            }
        }
        return null;
    }

    private static SessionInfo performTokenBasedAuthentication(AuthenticationContext context) {
        String token = context.getUserCredentials();
        User user = UserProvider.get().getUserByToken(token);
        if (user != null) {
            HTTPAuthentication.verifyUserCanLogin(user);
            return SessionManagementProvider.getSessionManagement().openOneShotSession(user, context.getHttpServletRequest());
        }
        return null;
    }

    private static void verifyUserCanLogin(User user) {
        if (user != null) {
            try {
                AuthenticationUserVerifierFactory.getUserCanLoginVerifier((User)user).verify();
            }
            catch (AuthenticationException e) {
                SilverLogger.getLogger(HTTPAuthentication.class).error((Throwable)e);
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
    }

    static {
        schemeHandlers.put(AuthenticationScheme.BASIC, HTTPAuthentication::performBasicAuthentication);
        schemeHandlers.put(AuthenticationScheme.BEARER, HTTPAuthentication::performTokenBasedAuthentication);
    }

    private static class AuthenticationInternalException
    extends SilverpeasRuntimeException {
        public AuthenticationInternalException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AuthenticationContext {
        private String credentials;
        private AuthenticationScheme scheme;
        private final HttpServletResponse response;
        private final HttpServletRequest request;

        public AuthenticationContext(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public String getUserCredentials() {
            return this.credentials;
        }

        public void setUserCredentials(String credentials) {
            this.credentials = credentials;
        }

        public AuthenticationScheme getAuthenticationScheme() {
            return this.scheme;
        }

        public void setAuthenticationScheme(AuthenticationScheme scheme) {
            this.scheme = scheme;
        }

        public HttpServletResponse getHttpServletResponse() {
            return this.response;
        }

        public HttpServletRequest getHttpServletRequest() {
            return this.request;
        }
    }
}

