/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import org.odftoolkit.odfdom.dom.element.form.FormButtonElement;
import org.odftoolkit.odfdom.dom.element.form.FormCheckboxElement;
import org.odftoolkit.odfdom.dom.element.form.FormComboboxElement;
import org.odftoolkit.odfdom.dom.element.form.FormFixedTextElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormattedTextElement;
import org.odftoolkit.odfdom.dom.element.form.FormListboxElement;
import org.odftoolkit.odfdom.dom.element.form.FormRadioElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeFormsElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.draw.ControlContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.form.Button;
import org.odftoolkit.simple.form.CheckBox;
import org.odftoolkit.simple.form.ComboBox;
import org.odftoolkit.simple.form.CurrencyField;
import org.odftoolkit.simple.form.DateField;
import org.odftoolkit.simple.form.Field;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.odftoolkit.simple.form.FormTypeDefinition;
import org.odftoolkit.simple.form.Label;
import org.odftoolkit.simple.form.ListBox;
import org.odftoolkit.simple.form.NumericField;
import org.odftoolkit.simple.form.OOFormProvider;
import org.odftoolkit.simple.form.PatternField;
import org.odftoolkit.simple.form.RadioButton;
import org.odftoolkit.simple.form.TextBox;
import org.odftoolkit.simple.form.TimeField;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class OOForm
extends Component
implements Form {
    private FormFormElement mElement;
    private Document mOwnerDocument;
    protected OfficeFormsElement mFormContainerElement;
    private int controlCount;

    private OOForm(FormFormElement element) {
        this.mElement = element;
        this.mOwnerDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
        this.mFormContainerElement = (OfficeFormsElement)this.mElement.getParentNode();
    }

    static OOForm createForm(String name, OfficeFormsElement parent) {
        OOForm form = null;
        if (parent != null) {
            FormFormElement element = parent.newFormFormElement();
            form = new OOForm(element);
            form.setFormName(name);
            form.setControlImplementation("ooo:com.sun.star.form.component.Form");
            Component.registerComponent(form, (OdfElement)element);
        }
        return form;
    }

    @Override
    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    public static Form getInstance(FormFormElement element) {
        OOForm form = null;
        form = (OOForm)Component.getComponentByElement((OdfElement)element);
        if (form == null) {
            form = new OOForm(element);
            Component.registerComponent(form, (OdfElement)element);
        }
        return form;
    }

    @Override
    public Button createButton(ControlContainer parent, FrameRectangle rectangle, String name, String label) {
        FormButtonElement btnElement = this.mElement.newFormButtonElement(FormTypeDefinition.FormImageLocation.CENTER.toString(), this.generateFormId());
        Button btnForm = new Button(btnElement);
        Component.registerComponent(btnForm, (OdfElement)btnElement);
        btnForm.setId(btnElement.getXmlIdAttribute());
        btnForm.setName(name);
        btnForm.setControlImplementation("ooo:com.sun.star.form.component.CommandButton");
        btnForm.setLabel(label);
        btnForm.setFormProperty("DefaultControl", "string", "com.sun.star.form.control.CommandButton", null, null, null, null, null);
        btnForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            btnForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            btnForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        btnForm.setRectangle(rectangle);
        return btnForm;
    }

    @Override
    public FormControl createLabel(ControlContainer parent, FrameRectangle rectangle, String name, String text) {
        FormFixedTextElement fixedTElement = this.mElement.newFormFixedTextElement(this.generateFormId());
        Label labelForm = new Label(fixedTElement);
        Component.registerComponent(labelForm, (OdfElement)fixedTElement);
        labelForm.setId(fixedTElement.getXmlIdAttribute());
        labelForm.setControlImplementation("ooo:com.sun.star.form.component.FixedText");
        labelForm.setName(name);
        labelForm.setLabel(text);
        labelForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            labelForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            labelForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        labelForm.setRectangle(rectangle);
        return labelForm;
    }

    @Override
    public FormControl createTextBox(ControlContainer parent, FrameRectangle rectangle, String name, String defaultText, boolean isMultipleLine) {
        String formId = this.generateFormId();
        Object textBoxElement = isMultipleLine ? this.mElement.newFormTextareaElement(formId) : this.mElement.newFormTextElement(formId);
        TextBox textBoxForm = new TextBox((OdfElement)textBoxElement);
        Component.registerComponent(textBoxForm, (OdfElement)textBoxElement);
        textBoxForm.setId(formId);
        textBoxForm.setName(name);
        textBoxForm.setControlImplementation("ooo:com.sun.star.form.component.TextField");
        textBoxForm.setValue(defaultText);
        textBoxForm.setCurrentValue(defaultText);
        textBoxForm.setFormProperty("DefaultControl", "string", "com.sun.star.form.control.TextField", null, null, null, null, null);
        if (isMultipleLine) {
            textBoxForm.setFormProperty("MultiLine", "boolean", null, true, null, null, null, null);
        }
        textBoxForm.setFormProperty("ObjIDinMSO", "float", null, null, null, null, 0.0, null);
        textBoxForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            textBoxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            textBoxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        textBoxForm.setRectangle(rectangle);
        return textBoxForm;
    }

    @Override
    public FormControl createListBox(ControlContainer parent, FrameRectangle rectangle, String name, boolean isMultiSelection, boolean isDropDown) {
        String formId = this.generateFormId();
        FormListboxElement listBoxElement = this.mElement.newFormListboxElement(this.generateFormId());
        ListBox listBoxForm = new ListBox(listBoxElement);
        Component.registerComponent(listBoxForm, (OdfElement)listBoxElement);
        listBoxForm.setId(formId);
        listBoxForm.setName(name);
        listBoxForm.setControlImplementation("ooo:com.sun.star.form.component.ListBox");
        listBoxForm.setFormMultiSelection(isMultiSelection);
        if (isDropDown) {
            listBoxForm.setFormDropdown(true);
        }
        listBoxForm.setFormProperty("ComplexStringItemList", "float", null, null, null, null, null, null);
        listBoxForm.setFormProperty("DefaultControl", "string", "com.sun.star.form.control.ListBox", null, null, null, null, null);
        listBoxForm.setFormProperty("ControlTypeinMSO", "float", null, null, null, null, 0.0, null);
        listBoxForm.setFormProperty("FocusedItem", "float", null, null, null, null, 0.0, null);
        listBoxForm.setFormProperty("ExtMultiSelection", "float", null, null, null, null, 0.0, null);
        listBoxForm.setFormProperty("ObjIDinMSO", "float", null, null, null, null, 0.0, null);
        listBoxForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            listBoxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            listBoxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        listBoxForm.setRectangle(rectangle);
        return listBoxForm;
    }

    @Override
    public FormControl createComboBox(ControlContainer parent, FrameRectangle rectangle, String name, String defaultText, boolean isDropDown) {
        String formId = this.generateFormId();
        FormComboboxElement comboElement = this.mElement.newFormComboboxElement(formId);
        ComboBox comboBoxForm = new ComboBox(comboElement);
        Component.registerComponent(comboBoxForm, (OdfElement)comboElement);
        comboBoxForm.setId(formId);
        comboBoxForm.setControlImplementation("ooo:com.sun.star.form.component.ComboBox");
        comboBoxForm.setName(name);
        if (defaultText != null) {
            comboBoxForm.setCurrentValue(defaultText);
            comboBoxForm.setValue(defaultText);
        }
        if (isDropDown) {
            comboBoxForm.setFormDropdown(true);
        }
        comboBoxForm.setFormProperty("ComplexStringItemList", "float", null, null, null, null, null, null);
        comboBoxForm.setFormProperty("DefaultControl", "string", "com.sun.star.form.control.ComboBox", null, null, null, null, null);
        comboBoxForm.setFormProperty("ControlTypeinMSO", "float", null, null, null, null, 0.0, null);
        comboBoxForm.setFormProperty("ObjIDinMSO", "float", null, null, null, null, 0.0, null);
        comboBoxForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            comboBoxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            comboBoxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        comboBoxForm.setRectangle(rectangle);
        return comboBoxForm;
    }

    @Override
    public FormControl createRadioButton(ControlContainer parent, FrameRectangle rectangle, String name, String label, String value) {
        String formId = this.generateFormId();
        FormRadioElement radioElement = this.mElement.newFormRadioElement("center", formId);
        RadioButton radioBtnForm = new RadioButton(radioElement);
        Component.registerComponent(radioBtnForm, (OdfElement)radioElement);
        radioBtnForm.setId(formId);
        radioBtnForm.setControlImplementation("ooo:com.sun.star.form.component.RadioButton");
        radioBtnForm.setLabel(label);
        radioBtnForm.setName(name);
        radioBtnForm.setValue(value);
        radioBtnForm.setFormProperty("ControlTypeinMSO", "float", null, null, null, null, 0.0, null);
        radioBtnForm.setFormProperty("DefaultControl", "string", "com.sun.star.form.control.RadioButton", null, null, null, null, null);
        radioBtnForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            radioBtnForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            radioBtnForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        radioBtnForm.setRectangle(rectangle);
        return radioBtnForm;
    }

    @Override
    public FormControl createCheckBox(ControlContainer parent, FrameRectangle rectangle, String name, String label, String value) {
        String formId = this.generateFormId();
        FormCheckboxElement checkboxElement = this.mElement.newFormCheckboxElement("center", formId);
        CheckBox checkboxForm = new CheckBox(checkboxElement);
        Component.registerComponent(checkboxForm, (OdfElement)checkboxElement);
        checkboxForm.setId(formId);
        checkboxForm.setName(name);
        checkboxForm.setControlImplementation("ooo:com.sun.star.form.component.CheckBox");
        checkboxForm.setLabel(label);
        checkboxForm.setValue(value);
        checkboxForm.setFormProperty("ControlTypeinMSO", "float", null, null, null, null, 0.0, null);
        checkboxForm.setFormProperty("DefaultControl", "string", "com.sun.star.form.control.CheckBox", null, null, null, null, null);
        checkboxForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            checkboxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            checkboxForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        checkboxForm.setRectangle(rectangle);
        return checkboxForm;
    }

    @Override
    public FormControl createDateField(ControlContainer parent, FrameRectangle rectangle, String name, String defaultValue) {
        return this.createField(OOFormProvider.FieldType.DATE_FIELD, parent, rectangle, name, defaultValue);
    }

    @Override
    public FormControl createTimeField(ControlContainer parent, FrameRectangle rectangle, String name, String defaultValue) {
        return this.createField(OOFormProvider.FieldType.TIME_FIELD, parent, rectangle, name, defaultValue);
    }

    @Override
    public FormControl createNumericField(ControlContainer parent, FrameRectangle rectangle, String name, String defaultValue) {
        return this.createField(OOFormProvider.FieldType.NUMERIC_FIELD, parent, rectangle, name, defaultValue);
    }

    @Override
    public FormControl createPatternField(ControlContainer parent, FrameRectangle rectangle, String name, String defaultValue) {
        return this.createField(OOFormProvider.FieldType.PATTERN_FIELD, parent, rectangle, name, defaultValue);
    }

    @Override
    public FormControl createCurrencyField(ControlContainer parent, FrameRectangle rectangle, String name, String defaultValue) {
        return this.createField(OOFormProvider.FieldType.CURRENCY_FIELD, parent, rectangle, name, defaultValue);
    }

    private FormControl createField(OOFormProvider.FieldType type, ControlContainer parent, FrameRectangle rectangle, String name, String defaultValue) {
        String formId = this.generateFormId();
        FormFormattedTextElement formattedTextElement = this.mElement.newFormFormattedTextElement(formId);
        Field fieldForm = null;
        String defaultControl = null;
        String controlImpl = null;
        switch (type) {
            case DATE_FIELD: {
                defaultControl = "com.sun.star.form.control.DateField";
                controlImpl = "ooo:com.sun.star.form.component.DateField";
                fieldForm = new DateField(formattedTextElement);
                break;
            }
            case TIME_FIELD: {
                defaultControl = "com.sun.star.form.control.TimeField";
                controlImpl = "ooo:com.sun.star.form.component.TimeField";
                fieldForm = new TimeField(formattedTextElement);
                break;
            }
            case NUMERIC_FIELD: {
                defaultControl = "com.sun.star.form.control.NumericField";
                controlImpl = "ooo:com.sun.star.form.component.NumericField";
                fieldForm = new NumericField(formattedTextElement);
                break;
            }
            case PATTERN_FIELD: {
                defaultControl = "com.sun.star.form.control.PatternField";
                controlImpl = "ooo:com.sun.star.form.component.PatternField";
                fieldForm = new PatternField(formattedTextElement);
                break;
            }
            case CURRENCY_FIELD: {
                defaultControl = "com.sun.star.form.control.CurrencyField";
                controlImpl = "ooo:com.sun.star.form.component.CurrencyField";
                fieldForm = new CurrencyField(formattedTextElement);
            }
        }
        if (fieldForm == null) {
            throw new RuntimeException("Fail to create a field.");
        }
        Component.registerComponent(fieldForm, (OdfElement)formattedTextElement);
        fieldForm.setName(name);
        fieldForm.setId(formId);
        fieldForm.setControlImplementation(controlImpl);
        fieldForm.setValue(defaultValue);
        fieldForm.setCurrentValue(defaultValue);
        fieldForm.setFormProperty("ControlTypeinMSO", "float", null, null, null, null, 0.0, null);
        fieldForm.setFormProperty("DefaultControl", "string", defaultControl, null, null, null, null, null);
        fieldForm.createDrawControl(parent);
        if (parent instanceof TextDocument) {
            fieldForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PAGE);
        } else {
            fieldForm.setAnchorType(StyleTypeDefinitions.AnchorType.TO_PARAGRAPH);
        }
        fieldForm.setRectangle(rectangle);
        return fieldForm;
    }

    private String generateFormId() {
        return this.getFormName() + ++this.controlCount;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        this.mElement.setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public void setFormName(String name) {
        this.mElement.setFormNameAttribute(name);
    }

    @Override
    public void setCommand(String command) {
        this.mElement.setFormCommandAttribute(command);
    }

    @Override
    public void setCommandType(FormTypeDefinition.FormCommandType commandType) {
        this.mElement.setFormCommandTypeAttribute(commandType.toString());
    }

    @Override
    public void setDataSource(String dataSource) {
        this.mElement.setFormDatasourceAttribute(dataSource);
    }

    @Override
    public FormFormElement getOdfElement() {
        return this.mElement;
    }

    @Override
    public String getFormName() {
        return this.mElement.getFormNameAttribute();
    }

    @Override
    public String getCommand() {
        return this.mElement.getFormCommandAttribute();
    }

    @Override
    public FormTypeDefinition.FormCommandType getCommandType() {
        return FormTypeDefinition.FormCommandType.enumValueOf(this.mElement.getFormCommandTypeAttribute());
    }

    @Override
    public String getControlImplementation() {
        return this.mElement.getFormControlImplementationAttribute();
    }

    @Override
    public String getDataSource() {
        return this.mElement.getFormDatasourceAttribute();
    }
}

