/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.atlas.iterator.ActionCount;
import org.apache.jena.atlas.iterator.FilterDistinctAdjacent;
import org.apache.jena.atlas.iterator.FilterUnique;
import org.apache.jena.atlas.iterator.IteratorCons;
import org.apache.jena.atlas.iterator.IteratorFlatMap;
import org.apache.jena.atlas.iterator.IteratorTruncate;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sink;

public class Iter<T>
implements Iterator<T> {
    private Iterator<T> iterator;

    public static <T> void forEach(Iterator<T> iter, Consumer<T> action) {
        iter.forEachRemaining(action);
    }

    public static <T> Stream<T> asStream(Iterator<T> iterator) {
        return Iter.asStream(iterator, false);
    }

    public static <T> Stream<T> asStream(Iterator<T> iterator, boolean parallel) {
        int characteristics = 1024;
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, characteristics), parallel);
    }

    public static <T> Iterator<T> singleton(T item) {
        return new SingletonIterator<T>(item);
    }

    public static <T> Iterator<T> nullIterator() {
        return Collections.emptyIterator();
    }

    public static <T> Set<T> toSet(Iterator<? extends T> stream) {
        return Iter.collect(stream, Collectors.toSet());
    }

    public static <T> List<T> toList(Iterator<? extends T> stream) {
        return Iter.collect(stream, Collectors.toList());
    }

    public static <T> Iterator<T> iterator(Iterator<? extends T> iterator) {
        List<T> x = Iter.toList(iterator);
        return x.iterator();
    }

    public static <T, R> R foldLeft(Iterator<? extends T> stream, R value, Folder<T, R> function) {
        while (stream.hasNext()) {
            T item = stream.next();
            value = function.apply(value, item);
        }
        return value;
    }

    public static <T, R> R foldRight(Iterator<? extends T> stream, R value, Folder<T, R> function) {
        if (!stream.hasNext()) {
            return value;
        }
        T item = stream.next();
        return function.apply(Iter.foldRight(stream, value, function), item);
    }

    public static <T> Optional<T> reduce(Iterator<T> iter, BinaryOperator<T> accumulator) {
        Object r = Iter.reduce(iter, null, accumulator);
        return Optional.ofNullable(r);
    }

    public static <T> T reduce(Iterator<T> iter, T identity, BinaryOperator<T> accumulator) {
        T result = identity;
        while (iter.hasNext()) {
            T elt = iter.next();
            result = result == null ? elt : accumulator.apply(result, elt);
        }
        return result;
    }

    public static <T> Optional<T> min(Iterator<T> iter, Comparator<T> comparator) {
        Object x = null;
        while (iter.hasNext()) {
            T elt = iter.next();
            if (x == null) {
                x = elt;
                continue;
            }
            int cmp = comparator.compare(x, elt);
            if (cmp <= 0) continue;
            x = elt;
        }
        return Optional.ofNullable(x);
    }

    public static <T> Optional<T> max(Iterator<T> iter, Comparator<T> comparator) {
        Object x = null;
        while (iter.hasNext()) {
            T elt = iter.next();
            if (x == null) {
                x = elt;
                continue;
            }
            int cmp = comparator.compare(x, elt);
            if (cmp >= 0) continue;
            x = elt;
        }
        return Optional.ofNullable(x);
    }

    public static <T, R> R collect(Iterator<T> iter, Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R result = supplier.get();
        while (iter.hasNext()) {
            T elt = iter.next();
            accumulator.accept(result, elt);
        }
        return result;
    }

    public static <T, R, A> R collect(Iterator<T> iter, Collector<? super T, A, R> collector) {
        A a = Iter.collect(iter, collector.supplier(), collector.accumulator());
        return collector.finisher().apply(a);
    }

    public static <T> void apply(Iterator<? extends T> stream, Consumer<T> action) {
        while (stream.hasNext()) {
            T item = stream.next();
            action.accept(item);
        }
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> stream, final Predicate<T> filter) {
        Iterator iter = new Iterator<T>(){
            boolean finished = false;
            boolean slotOccupied = false;
            T slot;

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                while (!this.slotOccupied) {
                    if (!stream.hasNext()) {
                        this.finished = true;
                        break;
                    }
                    Object nextItem = stream.next();
                    if (!filter.test(nextItem)) continue;
                    this.slot = nextItem;
                    this.slotOccupied = true;
                    break;
                }
                return this.slotOccupied;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.slotOccupied = false;
                    return this.slot;
                }
                throw new NoSuchElementException("filter.next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("filter.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> notFilter(Iterator<? extends T> stream, Predicate<T> filter) {
        return Iter.filter(stream, filter.negate());
    }

    @Deprecated
    public static <T> boolean every(Iterator<? extends T> iter, Predicate<T> predicate) {
        return Iter.allMatch(iter, predicate);
    }

    public static <T> boolean allMatch(Iterator<T> iter, Predicate<? super T> predicate) {
        while (iter.hasNext()) {
            T item = iter.next();
            if (predicate.test(item)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <T> boolean some(Iterator<T> iter, Predicate<? super T> predicate) {
        return Iter.anyMatch(iter, predicate);
    }

    public static <T> boolean anyMatch(Iterator<T> iter, Predicate<? super T> predicate) {
        while (iter.hasNext()) {
            T item = iter.next();
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean noneMatch(Iterator<T> iter, Predicate<? super T> predicate) {
        return !Iter.anyMatch(iter, predicate);
    }

    public static <T> Optional<T> findFirst(Iterator<T> iter, Predicate<? super T> predicate) {
        while (iter.hasNext()) {
            T item = iter.next();
            if (!predicate.test(item)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> findAny(Iterator<T> iter, Predicate<? super T> predicate) {
        return Iter.findFirst(iter, predicate);
    }

    public static <T, R> Iterator<R> map(final Iterator<? extends T> stream, final Function<T, R> converter) {
        Iterator iter = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public R next() {
                return converter.apply(stream.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("map.remove");
            }
        };
        return iter;
    }

    @Deprecated
    public static <T, R> List<R> map(List<? extends T> list, Function<T, R> converter) {
        return Iter.toList(Iter.map(list.iterator(), converter));
    }

    public static <T, R> Iterator<R> flatMap(Iterator<T> iter, Function<T, Iterator<R>> mapper) {
        return new IteratorFlatMap<T, R>(iter, mapper);
    }

    public static <T> Iterator<T> operate(final Iterator<? extends T> stream, final Consumer<T> action) {
        Iterator iter = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public T next() {
                Object t = stream.next();
                action.accept(t);
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operate.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> printWrapper(Iterator<? extends T> stream) {
        return Iter.printWrapper(System.out, stream);
    }

    public static <T> Iterator<T> printWrapper(PrintStream out, Iterator<? extends T> stream) {
        return Iter.operate(stream, out::println);
    }

    public static <T> Iterator<T> append(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        return IteratorCons.create(iter1, iter2);
    }

    public static <T> Iterator<T> distinct(Iterator<T> iter) {
        return Iter.filter(iter, new FilterUnique());
    }

    public static <T> Iterator<T> distinctAdjacent(Iterator<T> iter) {
        return Iter.filter(iter, new FilterDistinctAdjacent());
    }

    public static <T> Iterator<T> removeNulls(Iterator<T> iter) {
        return Iter.filter(iter, Objects::nonNull);
    }

    public static int step(Iterator<?> iter, int steps) {
        for (int i = 0; i < steps; ++i) {
            if (!iter.hasNext()) {
                return i;
            }
            iter.next();
        }
        return steps;
    }

    public static <T> List<T> take(Iterator<T> iter, int N) {
        iter = new IteratorN<T>(iter, N);
        ArrayList<T> x = new ArrayList<T>(N);
        while (iter.hasNext()) {
            x.add(iter.next());
        }
        return x;
    }

    public static <T> Iterator<T> takeWhile(Iterator<T> iter, Predicate<T> predicate) {
        return new IteratorTruncate<T>(iter, predicate);
    }

    public static <T> Iterator<T> takeUntil(Iterator<T> iter, Predicate<T> predicate) {
        return new IteratorTruncate<T>(iter, predicate.negate());
    }

    public static <T> Iterator<T> dropWhile(Iterator<T> iter, Predicate<T> predicate) {
        T elt;
        PeekIterator<T> iter2 = new PeekIterator<T>(iter);
        do {
            if ((elt = iter2.peek()) != null) continue;
            return Iter.nullIterator();
        } while (predicate.test(elt));
        return iter2;
    }

    public static <T> Iterator<T> dropUntil(Iterator<T> iter, Predicate<T> predicate) {
        return Iter.dropWhile(iter, predicate.negate());
    }

    public static <X> Iterator<X> limit(final Iterator<X> iterator, final long limit) {
        Iterator iter = new Iterator<X>(){
            private long count = 0L;

            @Override
            public boolean hasNext() {
                if (this.count < limit) {
                    return iterator.hasNext();
                }
                return false;
            }

            @Override
            public X next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object t = this.next();
                ++this.count;
                return t;
            }
        };
        return iter;
    }

    public static <X> Iterator<X> skip(Iterator<X> iterator, long limit) {
        for (long i = 0L; i < limit && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return iterator;
    }

    public static <T> long count(Iterator<T> iterator) {
        long x = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++x;
        }
        return x;
    }

    public static <T> void consume(Iterator<T> iterator) {
        Iter.count(iterator);
    }

    public static <T> String asString(Iterator<T> stream, String sep) {
        return Iter.iter(stream).map(x -> x.toString()).collect(Collectors.joining(sep));
    }

    public static <T> String asString(Iterator<T> stream, CharSequence sep, CharSequence prefix, CharSequence suffix) {
        return Iter.iter(stream).map(x -> x.toString()).collect(Collectors.joining(sep, prefix, suffix));
    }

    public static <T> void close(Iterator<T> iter) {
        if (iter instanceof Closeable) {
            ((Closeable)((Object)iter)).close();
        }
    }

    public static <T> Iterator<T> log(Iterator<T> stream) {
        return Iter.log(System.out, stream);
    }

    public static <T> Iterator<T> log(PrintStream out, Iterator<T> stream) {
        Iterator<T> iter = Iter.debug(out, stream);
        return Iter.toList(iter).iterator();
    }

    public static <T> Iterator<T> debug(Iterator<T> stream) {
        return Iter.debug(System.out, stream);
    }

    public static <T> Iterator<T> debug(PrintStream out, Iterator<T> stream) {
        try {
            Iterator<Object> iterator = Iter.map(stream, (T item) -> {
                out.println(item);
                return item;
            });
            return iterator;
        }
        finally {
            out.flush();
        }
    }

    public static <T> void print(Iterator<T> stream) {
        Iter.print(System.out, stream);
    }

    public static <T> void print(PrintStream out, Iterator<T> stream) {
        Iter.apply(stream, out::println);
    }

    public static <T> void sendToSink(Iterator<T> iter, Sink<T> sink) {
        while (iter.hasNext()) {
            T thing = iter.next();
            sink.send(thing);
        }
        sink.close();
    }

    @Deprecated
    public static <T> void sendToSink(Iterable<T> stream, Sink<T> sink) {
        Iter.sendToSink(stream.iterator(), sink);
    }

    public static <T> Iter<T> iter(Iter<T> iter) {
        return iter;
    }

    public static <T> Iter<T> iter(Collection<T> collection) {
        return Iter.iter(collection.iterator());
    }

    public static <T> Iter<T> iter(Iterator<T> iterator) {
        if (iterator instanceof Iter) {
            return (Iter)iterator;
        }
        return new Iter<T>(iterator);
    }

    public static <T> Iter<T> singletonIter(T item) {
        return Iter.iter(new SingletonIterator<T>(item));
    }

    public static <T> Iter<T> nullIter() {
        return Iter.iter(new NullIterator());
    }

    public static <T> Iterator<T> materialize(Iterator<T> iter) {
        return Iter.toList(iter).iterator();
    }

    public static <T> Iter<T> concat(Iter<T> iter1, Iter<T> iter2) {
        if (iter1 == null) {
            return iter2;
        }
        if (iter2 == null) {
            return iter1;
        }
        return iter1.append(iter2);
    }

    public static <T> Iter<T> concat(Iterator<T> iter1, Iterator<T> iter2) {
        if (iter1 == null) {
            return Iter.iter(iter2);
        }
        if (iter2 == null) {
            return Iter.iter(iter1);
        }
        return Iter.iter(iter1).append(Iter.iter(iter2));
    }

    public static <T> T first(Iterator<T> iter) {
        return (T)Iter.first(iter, (T x) -> true);
    }

    public static <T> T first(Iterator<T> iter, Predicate<T> filter) {
        while (iter.hasNext()) {
            T t = iter.next();
            if (!filter.test(t)) continue;
            return t;
        }
        return null;
    }

    @Deprecated
    public static <T> T first(Collection<T> collection, Predicate<T> filter) {
        return collection.stream().filter(filter).findFirst().orElse(null);
    }

    public static <T> int firstIndex(Iterator<T> iter, Predicate<T> filter) {
        int idx = 0;
        while (iter.hasNext()) {
            T t = iter.next();
            if (filter.test(t)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Deprecated
    public static <T> int firstIndex(Collection<T> collection, Predicate<T> filter) {
        return Iter.firstIndex(collection.iterator(), filter);
    }

    public static <T> T last(Iterator<T> iter) {
        return (T)Iter.last(iter, (T x) -> true);
    }

    public static <T> T last(Iterator<T> iter, Predicate<T> filter) {
        T thing = null;
        while (iter.hasNext()) {
            T t = iter.next();
            if (!filter.test(t)) continue;
            thing = t;
        }
        return thing;
    }

    @Deprecated
    public static <T> T last(Collection<T> collection, Predicate<T> filter) {
        return Iter.last(collection.iterator(), filter);
    }

    public static <T> int lastIndex(Iterator<T> iter, Predicate<T> filter) {
        int location = -1;
        int idx = 0;
        while (iter.hasNext()) {
            T t = iter.next();
            if (filter.test(t)) {
                location = idx;
            }
            ++idx;
        }
        return location;
    }

    @Deprecated
    public static <T> int lastIndex(Collection<T> collection, Predicate<T> filter) {
        return Iter.lastIndex(collection.iterator(), filter);
    }

    private Iter(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public void forEach(Consumer<T> action) {
        this.iterator.forEachRemaining(action);
    }

    public Set<T> toSet() {
        return Iter.toSet(this.iterator);
    }

    public List<T> toList() {
        return Iter.toList(this.iterator);
    }

    public void sendToSink(Sink<T> sink) {
        Iter.sendToSink(this.iterator, sink);
    }

    public T first() {
        return Iter.first(this.iterator);
    }

    public T last() {
        return Iter.last(this.iterator);
    }

    public T first(Predicate<T> filter) {
        return Iter.first(this.iterator, filter);
    }

    public int firstIndex(Predicate<T> filter) {
        return Iter.firstIndex(this.iterator, filter);
    }

    public T last(Predicate<T> filter) {
        return Iter.last(this.iterator, filter);
    }

    public int lastIndex(Predicate<T> filter) {
        return Iter.lastIndex(this.iterator, filter);
    }

    public Iter<T> filter(Predicate<T> filter) {
        return Iter.iter(Iter.filter(this.iterator, filter));
    }

    public boolean every(Predicate<T> predicate) {
        return Iter.every(this.iterator, predicate);
    }

    public boolean some(Predicate<T> filter) {
        return Iter.some(this.iterator, filter);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return Iter.allMatch(this.iterator, predicate);
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        return Iter.anyMatch(this.iterator, predicate);
    }

    public boolean noneMatch(Predicate<? super T> predicate) {
        return Iter.noneMatch(this.iterator, predicate);
    }

    public Optional<T> findFirst(Predicate<? super T> predicate) {
        return Iter.findFirst(this.iterator, predicate);
    }

    public Optional<T> findAny(Predicate<? super T> predicate) {
        return Iter.findAny(this.iterator, predicate);
    }

    public Iter<T> removeNulls() {
        return Iter.iter(Iter.removeNulls(this));
    }

    public <R> Iter<R> map(Function<T, R> converter) {
        return Iter.iter(Iter.map(this.iterator, converter));
    }

    public <R> Iter<R> flatMap(Function<T, Iterator<R>> converter) {
        return Iter.iter(Iter.flatMap(this.iterator, converter));
    }

    public Iter<T> operate(Consumer<T> action) {
        return Iter.iter(Iter.operate(this.iterator, action));
    }

    public <R> R foldLeft(R initial, Folder<T, R> accumulator) {
        return Iter.foldLeft(this.iterator, initial, accumulator);
    }

    public <R> R foldRight(R initial, Folder<T, R> accumulator) {
        return Iter.foldRight(this.iterator, initial, accumulator);
    }

    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return Iter.reduce(this.iterator, accumulator);
    }

    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return Iter.reduce(this.iterator, identity, accumulator);
    }

    public Optional<T> min(Comparator<T> comparator) {
        return Iter.min(this.iterator, comparator);
    }

    public Optional<T> max(Comparator<T> comparator) {
        return Iter.max(this.iterator, comparator);
    }

    public <R> R collect(Supplier<R> supplier, BiConsumer<R, T> accumulator) {
        return Iter.collect(this.iterator, supplier, accumulator);
    }

    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return Iter.collect(this.iterator, collector);
    }

    public void apply(Consumer<T> action) {
        Iter.apply(this.iterator, action);
    }

    public Iter<T> append(Iterator<T> iter) {
        return Iter.iter(IteratorCons.create(this.iterator, iter));
    }

    public Iter<T> take(int N) {
        return Iter.iter(Iter.take(this.iterator, N));
    }

    public Iter<T> takeWhile(Predicate<T> predicate) {
        return Iter.iter(Iter.takeWhile(this.iterator, predicate));
    }

    public Iter<T> takeUntil(Predicate<T> predicate) {
        return Iter.iter(Iter.takeUntil(this.iterator, predicate));
    }

    public Iter<T> dropWhile(Predicate<T> predicate) {
        return Iter.iter(Iter.dropWhile(this.iterator, predicate));
    }

    public Iter<T> dropUntil(Predicate<T> predicate) {
        return Iter.iter(Iter.dropWhile(this.iterator, predicate.negate()));
    }

    public Iter<T> limit(long N) {
        return Iter.iter(Iter.limit(null, N));
    }

    public Iter<T> skip(long N) {
        return Iter.iter(Iter.skip(null, N));
    }

    public long count() {
        ActionCount action = new ActionCount();
        this.apply(action);
        return action.getCount();
    }

    public Iter<T> distinct() {
        return Iter.iter(Iter.distinct(this.iterator));
    }

    public Iter<T> distinctAdjacent() {
        return Iter.iter(Iter.distinctAdjacent(this.iterator));
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    static class IteratorN<T>
    implements Iterator<T> {
        private final Iterator<T> iter;
        private final int N;
        private int count;

        IteratorN(Iterator<T> iter, int N) {
            this.iter = iter;
            this.N = N;
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.count >= this.N) {
                return false;
            }
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            if (this.count >= this.N) {
                throw new NoSuchElementException();
            }
            T x = this.iter.next();
            ++this.count;
            return x;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    @FunctionalInterface
    public static interface Folder<X, Y>
    extends BiFunction<Y, X, Y> {
    }
}

