/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;

class IncludeAllMatcher
implements Matcher {
    private final String matchingPath;
    private final int depth;

    IncludeAllMatcher(String matchingPath, int depth) {
        Preconditions.checkArgument((depth > 0 ? 1 : 0) != 0);
        this.matchingPath = matchingPath;
        this.depth = depth;
    }

    @Override
    public Matcher next(String name) {
        return new IncludeAllMatcher(PathUtils.concat((String)this.matchingPath, (String)name), this.depth + 1);
    }

    @Override
    public boolean isMatch() {
        return true;
    }

    @Override
    public String getMatchedPath() {
        return this.matchingPath;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public boolean matchesAllChildren() {
        return true;
    }

    public String toString() {
        return "ALL - " + this.matchingPath;
    }
}

