/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.StringBasedBlob;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

public class BinaryPropertyState
extends SinglePropertyState<Blob> {
    private final Blob value;

    public BinaryPropertyState(@NotNull String name, @NotNull Blob value) {
        super(name);
        this.value = (Blob)Preconditions.checkNotNull((Object)value);
    }

    public static PropertyState binaryProperty(@NotNull String name, @NotNull byte[] value) {
        return new BinaryPropertyState(name, new ArrayBasedBlob((byte[])Preconditions.checkNotNull((Object)value)));
    }

    public static PropertyState binaryProperty(@NotNull String name, @NotNull String value) {
        return new BinaryPropertyState(name, new StringBasedBlob((String)Preconditions.checkNotNull((Object)value)));
    }

    public static PropertyState binaryProperty(@NotNull String name, @NotNull Blob value) {
        return new BinaryPropertyState(name, value);
    }

    public static PropertyState binaryProperty(@NotNull String name, @NotNull Value value) throws RepositoryException {
        return new BinaryPropertyState(name, BinaryPropertyState.getBlob(value));
    }

    @Override
    public Blob getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public long size() {
        return this.value.length();
    }

    public Type<?> getType() {
        return Type.BINARY;
    }
}

