/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class MongoBlob
implements Bson {
    public static final String KEY_ID = "_id";
    public static final String KEY_DATA = "data";
    public static final String KEY_LAST_MOD = "lastMod";
    public static final String KEY_LEVEL = "level";
    private String id;
    private byte[] data;
    private int level;
    private long lastMod;

    static MongoBlob fromDocument(Document doc) {
        MongoBlob blob = new MongoBlob();
        blob.setId(doc.getString((Object)KEY_ID));
        blob.setLevel(doc.getInteger((Object)KEY_LEVEL, 0));
        if (doc.containsKey((Object)KEY_LAST_MOD)) {
            blob.setLastMod(doc.getLong((Object)KEY_LAST_MOD));
        }
        if (doc.containsKey((Object)KEY_DATA)) {
            blob.setData(((Binary)doc.get((Object)KEY_DATA, Binary.class)).getData());
        }
        return blob;
    }

    Document asDocument() {
        Document doc = new Document();
        doc.put(KEY_ID, (Object)this.id);
        doc.put(KEY_LEVEL, (Object)this.level);
        doc.put(KEY_LAST_MOD, (Object)this.lastMod);
        doc.put(KEY_DATA, (Object)this.data);
        return doc;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public long getLastMod() {
        return this.lastMod;
    }

    public void setLastMod(long lastMod) {
        this.lastMod = lastMod;
    }

    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper((Object)this, (Encoder)codecRegistry.get(MongoBlob.class));
    }
}

