/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool.iotrace;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.segment.tool.iotrace.Trace;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class DepthFirstTrace
implements Trace {
    @NotNull
    public static final String CONTEXT_SPEC = "depth,count,path";
    private final int depth;
    @NotNull
    private final String path;
    @NotNull
    private final Consumer<List<String>> context;
    @NotNull
    private final AtomicInteger nodeCount = new AtomicInteger();

    public DepthFirstTrace(int depth, @NotNull String path, @NotNull Consumer<List<String>> context) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
        this.depth = depth;
        this.path = path;
        this.context = context;
    }

    @Override
    public void run(@NotNull NodeState node) {
        this.traverse(DepthFirstTrace.getNode(node, this.path), 0, this.path);
    }

    @NotNull
    private static NodeState getNode(@NotNull NodeState root, @NotNull String path) {
        NodeState node = root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private void traverse(NodeState node, int depth, @NotNull String path) {
        DepthFirstTrace.updateContext(this.context, depth, this.nodeCount.incrementAndGet(), path);
        if (depth < this.depth) {
            node.getChildNodeEntries().forEach(cse -> {
                String childPath = PathUtils.concat((String)path, (String)cse.getName());
                this.traverse(cse.getNodeState(), depth + 1, childPath);
            });
        }
    }

    private static void updateContext(@NotNull Consumer<List<String>> context, int depth, int count, @NotNull String path) {
        context.accept((List<String>)ImmutableList.of((Object)String.valueOf(depth), (Object)String.valueOf(count), (Object)path));
    }
}

