/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.components.kmelia.model.KmaxRuntimeException;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public class KmeliaXmlFormUpdateContext {
    private final Map<String, PublicationTemplate> templateCache = new HashMap<String, PublicationTemplate>();
    private final Map<String, Pair<PublicationTemplate, DataRecord>> dataRecordCache = new HashMap<String, Pair<PublicationTemplate, DataRecord>>();
    private final List<FileItem> items;
    private final MemoizedSupplier<String> xmlShortName;
    private final boolean forceUpdatePublication;
    private boolean batchProcessing = false;

    public KmeliaXmlFormUpdateContext(List<FileItem> items, boolean forceUpdatePublication) {
        this.items = items;
        this.forceUpdatePublication = forceUpdatePublication;
        this.xmlShortName = new MemoizedSupplier(() -> FileUploadUtil.getParameter((List)items, (String)"KmeliaPubFormName"));
    }

    public KmeliaXmlFormUpdateContext batchProcessing() {
        this.batchProcessing = true;
        return this;
    }

    public List<FileItem> getItems() {
        return this.items;
    }

    public boolean isForceUpdatePublication() {
        return this.forceUpdatePublication;
    }

    public boolean isBatchProcessing() {
        return this.batchProcessing;
    }

    public String getXmlFormShortNameFromItems() {
        return (String)this.xmlShortName.get();
    }

    public List<Pair<FileItem, FileField>> getPublicationFileFields(PublicationDetail pub, String language) {
        Pair<PublicationTemplate, DataRecord> pubData = this.getOrInitializePublicationDataRecordOf(pub, language);
        try {
            return ((PublicationTemplate)pubData.getFirst()).getUpdateForm().getFieldTemplates().stream().flatMap(ft -> IntStream.range(0, ft.getMaximumNumberOfOccurrences()).mapToObj(i -> {
                String fieldName = ft.getFieldName();
                Field field = ((DataRecord)pubData.getSecond()).getField(fieldName, i);
                if ("file".equals(field.getTypeName())) {
                    String inputName = Util.getFieldOccurrenceName((String)field.getName(), (int)field.getOccurrence());
                    FileItem item = FileUploadUtil.getFile(this.items, (String)inputName);
                    if (item != null && !item.isFormField() && StringUtil.isDefined((String)item.getName())) {
                        return Pair.of((Object)item, (Object)((FileField)field));
                    }
                    return Pair.of((Object)null, (Object)((FileField)field));
                }
                return null;
            }).filter(Objects::nonNull)).collect(Collectors.toList());
        }
        catch (PublicationTemplateException e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    public Pair<PublicationTemplate, DataRecord> getOrInitializePublicationDataRecordOf(PublicationDetail pub, String language) {
        return this.dataRecordCache.computeIfAbsent(pub.getId() + ":" + language, i -> {
            String externalId = pub.getInstanceId() + ":" + this.getXmlFormShortNameFromItems();
            PublicationTemplate template = this.getPublicationTemplate(externalId);
            try {
                RecordSet set = template.getRecordSet();
                String pubLanguage = pub.getLanguageToDisplay(language);
                DataRecord data = set.getRecord(pub.getId(), pubLanguage);
                if (data == null || pubLanguage != null && !pubLanguage.equals(data.getLanguage())) {
                    data = set.getEmptyRecord();
                    data.setId(pub.getId());
                    data.setLanguage(pubLanguage);
                }
                return Pair.of((Object)template, (Object)data);
            }
            catch (FormException | PublicationTemplateException e) {
                throw new KmeliaRuntimeException(e);
            }
        });
    }

    private PublicationTemplate getPublicationTemplate(String externalId) {
        return this.templateCache.computeIfAbsent(externalId, i -> {
            try {
                return this.getPublicationTemplateManager().getPublicationTemplate(i);
            }
            catch (PublicationTemplateException e) {
                throw new KmaxRuntimeException(e);
            }
        });
    }

    private PublicationTemplateManager getPublicationTemplateManager() {
        return PublicationTemplateManager.getInstance();
    }
}

