/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.Optional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.persistence.datasource.OperationContext;

public class KmeliaOperationContext {
    private static final String cacheKey = "@@@KmeliaOperationContext@@@";
    private final OperationType operation;

    public static Optional<KmeliaOperationContext> current() {
        return Optional.ofNullable((KmeliaOperationContext)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)cacheKey, KmeliaOperationContext.class));
    }

    public static void about(OperationType type) {
        KmeliaOperationContext context = new KmeliaOperationContext(type);
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)cacheKey, (Object)context);
    }

    private KmeliaOperationContext(OperationType type) {
        this.operation = type;
    }

    public boolean isAbout(OperationType type) {
        return this.operation == type;
    }

    public User getInvoker() {
        return OperationContext.fromCurrentRequester().getUser();
    }

    public static enum OperationType {
        CREATION,
        UPDATE,
        REMOVING,
        DELETION;

    }
}

