/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.descriptors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDescriptors
implements Descriptors {
    private final Descriptors base;
    private final Map<String, Descriptor> descriptors = new ConcurrentHashMap<String, Descriptor>();

    public GenericDescriptors() {
        this.base = null;
    }

    public GenericDescriptors(@Nullable Descriptors base) {
        this.base = base;
    }

    @NotNull
    public String[] getKeys() {
        HashSet<String> keys = new HashSet<String>(this.descriptors.keySet());
        if (this.base != null) {
            Collections.addAll(keys, this.base.getKeys());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public boolean isStandardDescriptor(@NotNull String key) {
        return this.descriptors.containsKey(key) && this.descriptors.get((Object)key).standard || this.base != null && this.base.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(@NotNull String key) {
        return this.descriptors.containsKey(key) && this.descriptors.get((Object)key).singleValued || this.base != null && this.base.isSingleValueDescriptor(key);
    }

    @Nullable
    public Value getValue(@NotNull String key) {
        Descriptor d = this.descriptors.get(key);
        if (d == null) {
            return this.base == null ? null : this.base.getValue(key);
        }
        return !d.singleValued ? null : d.values[0];
    }

    @Nullable
    public Value[] getValues(@NotNull String key) {
        Descriptor d = this.descriptors.get(key);
        if (d == null) {
            return this.base == null ? null : this.base.getValues(key);
        }
        return d.values;
    }

    public GenericDescriptors put(@NotNull String name, @NotNull Value[] values, boolean singleValued, boolean standard) {
        this.descriptors.put(name, new Descriptor(name, values, singleValued, standard));
        return this;
    }

    public GenericDescriptors put(@NotNull String name, @NotNull Value value, boolean singleValued, boolean standard) {
        this.descriptors.put(name, new Descriptor(name, new Value[]{value}, singleValued, standard));
        return this;
    }

    private static final class Descriptor {
        final String name;
        final Value[] values;
        final boolean singleValued;
        final boolean standard;

        public Descriptor(String name, Value[] values, boolean singleValued, boolean standard) {
            this.name = name;
            this.values = values;
            this.singleValued = singleValued;
            this.standard = standard;
        }
    }
}

