/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.record;

import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.field.TextFieldImpl;
import org.silverpeas.core.i18n.I18NHelper;

public class UserRecord
implements DataRecord {
    private static final long serialVersionUID = 4372981095216600600L;
    private final User user;

    public boolean isConnected() {
        return this.user.isConnected();
    }

    public UserRecord(User user) {
        this.user = user;
    }

    public User getUserDetail() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public void setId(String id) {
    }

    public Field[] getFields() {
        return new Field[0];
    }

    public Field getField(String fieldName) throws FormException {
        boolean sensitiveData;
        TextFieldImpl text = new TextFieldImpl();
        User requester = User.getCurrentRequester();
        boolean isAdmin = requester != null && (requester.isAccessAdmin() || requester.isAccessDomainManager() && requester.getDomainId().equals(this.user.getDomainId()));
        boolean bl = sensitiveData = this.user instanceof UserDetail && !isAdmin && ((UserDetail)this.user).hasSensitiveData();
        if ("Id".equals(fieldName)) {
            text.setStringValue(this.user.getId());
        } else if ("SpecificId".equals(fieldName) && this.user instanceof UserDetail) {
            text.setStringValue(((UserDetail)this.user).getSpecificId());
        } else if ("DomainId".equals(fieldName)) {
            text.setStringValue(this.user.getDomainId());
        } else if ("Login".equals(fieldName)) {
            text.setStringValue(this.user.getLogin());
        } else if ("FirstName".equals(fieldName)) {
            text.setStringValue(this.user.getFirstName());
        } else if ("LastName".equals(fieldName)) {
            text.setStringValue(this.user.getLastName());
        } else if ("Mail".equals(fieldName) && !sensitiveData) {
            text.setStringValue(this.user.getEmailAddress());
        } else if ("AccessLevel".equals(fieldName)) {
            text.setStringValue(this.user.getAccessLevel().code());
        } else if (fieldName.startsWith("DC.")) {
            String specificDetail = fieldName.substring(fieldName.indexOf(".") + 1);
            this.setSpecificDetail(specificDetail, sensitiveData, text);
        }
        return text;
    }

    private void setSpecificDetail(String specificDetail, boolean sensitiveData, TextFieldImpl text) {
        UserFull userFull;
        DomainProperty prop;
        if (!(!(this.user instanceof UserFull) || (prop = (userFull = (UserFull)this.user).getProperty(specificDetail)).isSensitive() && sensitiveData)) {
            text.setStringValue(((UserFull)this.user).getValue(specificDetail));
        }
    }

    public Field getField(String fieldName, int occurrence) {
        return null;
    }

    public Field getField(int fieldIndex) {
        return null;
    }

    public int size() {
        return -1;
    }

    public String[] getFieldNames() {
        return new String[0];
    }

    public boolean isNew() {
        return false;
    }

    public String getLanguage() {
        return I18NHelper.DEFAULT_LANGUAGE;
    }

    public void setLanguage(String language) {
    }

    public Map<String, String> getValues(String language) {
        return new HashMap<String, String>();
    }

    public ResourceReference getResourceReference() {
        return null;
    }
}

