/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.webpages;

import javax.inject.Inject;
import org.silverpeas.components.webpages.notification.WebPagesUserNotifier;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.content.wysiwyg.notification.WysiwygEvent;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.system.CDIResourceEventListener;

@Bean
public class WebPagesWysiwygEventListener
extends CDIResourceEventListener<WysiwygEvent> {
    @Inject
    private OrganizationController organisationController;

    public void onUpdate(WysiwygEvent event) {
        this.notifyUsersAboutChange((WysiwygContent)event.getTransition().getAfter());
    }

    public void onCreation(WysiwygEvent event) {
        this.notifyUsersAboutChange((WysiwygContent)event.getTransition().getAfter());
    }

    private void notifyUsersAboutChange(WysiwygContent content) {
        String userId = content.getAuthor().getId();
        String componentId = content.getContribution().getIdentifier().getComponentInstanceId();
        if ("yes".equals(this.organisationController.getComponentParameterValue(componentId, "useSubscription")) && this.isAboutWebPage(content)) {
            WebPagesUserNotifier.notify(new NodePK("0", componentId), userId);
        }
    }

    private boolean isAboutWebPage(WysiwygContent content) {
        LocalizedContribution contribution = content.getContribution();
        return !contribution.getIdentifier().getLocalId().startsWith("Node") && contribution.getIdentifier().getComponentInstanceId().startsWith("webPages");
    }
}

