/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo;

import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.model.QuickInfoService;
import org.silverpeas.components.quickinfo.model.QuickInfoServiceProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.UserAuthenticationListener;

@Service
@Singleton
public class QuickInfoUserAuthenticationListener
implements UserAuthenticationListener {
    public String firstHomepageAccessAfterAuthentication(HttpServletRequest request, User user, String finalURL) {
        return this.handle(request, user, finalURL);
    }

    public String homepageAccessFromLoginWhenUserSessionAlreadyOpened(HttpServletRequest request, User user, String finalURL) {
        return this.handle(request, user, finalURL);
    }

    private String handle(HttpServletRequest request, User user, String finalURL) {
        String redirectURL = null;
        if (user != null && !user.isAnonymous()) {
            HttpSession session = request.getSession();
            session.removeAttribute("Silverpeas_BlockingNews");
            session.removeAttribute("Silverpeas_FinalURL");
            List<News> news = this.getService().getUnreadBlockingNews(user.getId());
            if (!news.isEmpty()) {
                session.setAttribute("Silverpeas_BlockingNews", news);
                session.setAttribute("Silverpeas_FinalURL", (Object)finalURL);
                redirectURL = "/quickinfo/jsp/blockingNews.jsp";
            }
        }
        return redirectURL;
    }

    private QuickInfoService getService() {
        return QuickInfoServiceProvider.getQuickInfoService();
    }
}

