/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.model;

import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;

public class WhitePagesCard
implements Comparable<WhitePagesCard> {
    private long userCardId = 0L;
    private String instanceLabel;
    private String instanceId;

    public WhitePagesCard(String label) {
        this.instanceLabel = label;
    }

    public WhitePagesCard(long userCardId, String instanceId) {
        this.setInstanceId(instanceId);
        this.userCardId = userCardId;
    }

    public long getUserCardId() {
        return this.userCardId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceLabel() {
        return this.instanceLabel;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        ComponentInstLight app = organizationController.getComponentInstLight(instanceId);
        this.instanceLabel = app != null ? app.getLabel() : "";
    }

    public void setUserCardId(long userCardId) {
        this.userCardId = userCardId;
    }

    public boolean equals(Object theOther) {
        if (!(theOther instanceof WhitePagesCard)) {
            return false;
        }
        if (theOther.getClass() != this.getClass()) {
            return false;
        }
        return this.getInstanceLabel().equals(((WhitePagesCard)theOther).getInstanceLabel());
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (int)(this.userCardId ^ this.userCardId >>> 32);
        hash = 29 * hash + (this.instanceLabel != null ? this.instanceLabel.hashCode() : 0);
        hash = 29 * hash + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(WhitePagesCard theOther) {
        return this.getInstanceLabel().compareTo(theOther.getInstanceLabel());
    }
}

