/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterViewDocument {
    private static final Logger logger = LoggerFactory.getLogger(ClusterViewDocument.class);
    private static final String CLUSTERVIEW_DOC_ID = "clusterView";
    static final String VIEW_SEQ_NUM_KEY = "seqNum";
    static final String ACTIVE_KEY = "active";
    static final String INACTIVE_KEY = "inactive";
    static final String RECOVERING_KEY = "recovering";
    private static final String CREATED_KEY = "created";
    private static final String CREATOR_KEY = "creator";
    private static final String RETIRED_KEY = "retired";
    private static final String RETIRER_KEY = "retirer";
    private static final String CLUSTER_VIEW_HISTORY_KEY = "clusterViewHistory";
    static final int HISTORY_LIMIT = 10;
    private final long viewSeqNum;
    private final Integer[] activeIds;
    private final Integer[] recoveringIds;
    private final Integer[] inactiveIds;
    private final Map<Object, String> viewHistory;
    private final String createdAt;
    private final Long createdBy;

    static ClusterViewDocument readOrUpdate(DocumentNodeStore documentNodeStore, Set<Integer> activeIds, Set<Integer> recoveringIds, Set<Integer> inactiveIds) {
        ClusterViewDocument readResult;
        Long newViewSeqNum;
        logger.trace("readOrUpdate: expected: activeIds: {}, recoveringIds: {}, inactiveIds: {}", new Object[]{activeIds, recoveringIds, inactiveIds});
        if (activeIds == null || activeIds.size() == 0) {
            logger.info("readOrUpdate: activeIds must not be null or empty");
            throw new IllegalStateException("activeIds must not be null or empty");
        }
        int localClusterId = documentNodeStore.getClusterId();
        ClusterViewDocument previousView = ClusterViewDocument.doRead(documentNodeStore);
        if (previousView != null && previousView.matches(activeIds, recoveringIds, inactiveIds)) {
            logger.trace("readOrUpdate: view unchanged, returning: {}", (Object)previousView);
            return previousView;
        }
        logger.trace("readOrUpdate: view change detected, going to update from {} to activeIds: {}, recoveringIds: {}, inactiveIds: {}", new Object[]{previousView, activeIds, recoveringIds, inactiveIds});
        UpdateOp updateOp = new UpdateOp(CLUSTERVIEW_DOC_ID, true);
        Date now = new Date();
        updateOp.set(ACTIVE_KEY, ClusterViewDocument.setToCsv(activeIds));
        updateOp.set(RECOVERING_KEY, ClusterViewDocument.setToCsv(recoveringIds));
        updateOp.set(INACTIVE_KEY, ClusterViewDocument.setToCsv(inactiveIds));
        updateOp.set(CREATED_KEY, ISO8601.format((Date)now));
        updateOp.set(CREATOR_KEY, localClusterId);
        if (previousView != null) {
            Map<Object, String> previousHistory = previousView.getHistory();
            if (previousHistory != null) {
                Revision oldestRevision;
                HashMap<Object, String> mapClone = new HashMap<Object, String>(previousHistory);
                while (mapClone.size() >= 10 && (oldestRevision = ClusterViewDocument.oldestRevision(mapClone)) != null) {
                    updateOp.removeMapEntry(CLUSTER_VIEW_HISTORY_KEY, oldestRevision);
                    if (mapClone.remove(oldestRevision) != null) continue;
                    break;
                }
            }
            updateOp.setMapEntry(CLUSTER_VIEW_HISTORY_KEY, Revision.newRevision(localClusterId), ClusterViewDocument.asHistoryEntry(previousView, localClusterId, now));
        }
        if (previousView == null) {
            ArrayList<UpdateOp> updateOps = new ArrayList<UpdateOp>();
            newViewSeqNum = 1L;
            updateOp.setNew(true);
            updateOp.set(VIEW_SEQ_NUM_KEY, newViewSeqNum);
            updateOps.add(updateOp);
            logger.debug("updateAndRead: trying to create the first ever clusterView - hence {}={}", (Object)VIEW_SEQ_NUM_KEY, (Object)newViewSeqNum);
            if (!documentNodeStore.getDocumentStore().create(Collection.SETTINGS, updateOps)) {
                logger.debug("updateAndRead: someone else just created the first view ever while I tried - reread that one later");
                return null;
            }
        } else {
            Long previousViewSeqNum = previousView.getViewSeqNum();
            updateOp.setNew(false);
            updateOp.equals(VIEW_SEQ_NUM_KEY, null, previousViewSeqNum);
            newViewSeqNum = previousViewSeqNum + 1L;
            updateOp.set(VIEW_SEQ_NUM_KEY, newViewSeqNum);
            logger.debug("updateAndRead: trying to update the clusterView to {}={} ", (Object)VIEW_SEQ_NUM_KEY, (Object)newViewSeqNum);
            if (documentNodeStore.getDocumentStore().findAndUpdate(Collection.SETTINGS, updateOp) == null) {
                logger.debug("updateAndRead: someone else just updated the view which I wanted to do as well - reread that one later");
                return null;
            }
        }
        if ((readResult = ClusterViewDocument.doRead(documentNodeStore)) == null) {
            logger.debug("updateAndRead: got null from read - whatever the exact reason, we must retry in a moment.");
            return null;
        }
        if (newViewSeqNum.equals(readResult.getViewSeqNum())) {
            logger.debug("updateAndRead: matching view - no change");
            return readResult;
        }
        logger.debug("updateAndRead: someone else in the cluster was updating right after I also succeeded - re-read in a bit");
        return null;
    }

    private static Revision oldestRevision(Map<Object, String> historyMap) {
        String oldestRevision = null;
        for (Object obj : historyMap.keySet()) {
            String r = obj.toString();
            if (oldestRevision == null) {
                oldestRevision = r;
                continue;
            }
            if (Revision.getTimestampDifference(Revision.fromString(r), Revision.fromString(oldestRevision)) >= 0L) continue;
            oldestRevision = r;
        }
        if (oldestRevision == null) {
            return null;
        }
        return Revision.fromString(oldestRevision);
    }

    private static String asHistoryEntry(ClusterViewDocument previousView, int retiringClusterNodeId, Date retireTime) {
        if (previousView == null) {
            throw new IllegalArgumentException("previousView must not be null");
        }
        JsopBuilder b = new JsopBuilder();
        b.object();
        b.key(VIEW_SEQ_NUM_KEY);
        b.value(previousView.getViewSeqNum());
        b.key(CREATED_KEY);
        b.value(String.valueOf(previousView.getCreatedAt()));
        b.key(CREATOR_KEY);
        b.value(previousView.getCreatedBy());
        b.key(RETIRED_KEY);
        b.value(String.valueOf(ISO8601.format((Date)retireTime)));
        b.key(RETIRER_KEY);
        b.value((long)retiringClusterNodeId);
        b.key(ACTIVE_KEY);
        b.value(ClusterViewDocument.setToCsv(previousView.getActiveIds()));
        b.key(RECOVERING_KEY);
        b.value(ClusterViewDocument.setToCsv(previousView.getRecoveringIds()));
        b.key(INACTIVE_KEY);
        b.value(ClusterViewDocument.setToCsv(previousView.getInactiveIds()));
        b.endObject();
        String h = b.toString();
        return h;
    }

    private static String setToCsv(Set<Integer> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Integer id : ids) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(id);
        }
        return sb.toString();
    }

    static String arrayToCsv(Integer[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Integer a : arr) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(a);
        }
        return sb.toString();
    }

    static Integer[] csvToIntegerArray(String csv) {
        if (csv == null) {
            return null;
        }
        String[] split = csv.split(",");
        Integer[] result = new Integer[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    private static ClusterViewDocument doRead(DocumentNodeStore documentNodeStore) {
        DocumentStore documentStore = documentNodeStore.getDocumentStore();
        Document doc = documentStore.find(Collection.SETTINGS, CLUSTERVIEW_DOC_ID, -1);
        if (doc == null) {
            return null;
        }
        ClusterViewDocument clusterView = new ClusterViewDocument(doc);
        if (clusterView.isValid()) {
            return clusterView;
        }
        logger.warn("read: clusterView document is not valid: " + doc.format());
        return null;
    }

    static boolean matches(Integer[] expected, Set<Integer> actual) {
        boolean actualIsEmpty;
        boolean expectedIsEmpty = expected == null || expected.length == 0;
        boolean bl = actualIsEmpty = actual == null || actual.size() == 0;
        if (expectedIsEmpty && actualIsEmpty) {
            return true;
        }
        if (expectedIsEmpty != actualIsEmpty) {
            return false;
        }
        if (expected.length != actual.size()) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            Integer aMemberId = expected[i];
            if (actual.contains(aMemberId)) continue;
            return false;
        }
        return true;
    }

    ClusterViewDocument(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("doc must not be null");
        }
        this.viewSeqNum = (Long)doc.get(VIEW_SEQ_NUM_KEY);
        this.createdAt = (String)doc.get(CREATED_KEY);
        Object creatorId = doc.get(CREATOR_KEY);
        if (creatorId instanceof Number) {
            this.createdBy = ((Number)creatorId).longValue();
        } else if (creatorId == null) {
            this.createdBy = -1L;
        } else {
            throw new IllegalStateException("Unsupported type of creator: " + creatorId);
        }
        Object obj = doc.get(ACTIVE_KEY);
        if (obj == null || !(obj instanceof String)) {
            logger.trace("<init>: {} : {}", (Object)ACTIVE_KEY, obj);
            this.activeIds = new Integer[0];
        } else {
            this.activeIds = ClusterViewDocument.csvToIntegerArray((String)obj);
        }
        Object obj2 = doc.get(RECOVERING_KEY);
        if (obj2 == null || !(obj2 instanceof String)) {
            logger.trace("<init>: {} : {}", (Object)RECOVERING_KEY, obj2);
            this.recoveringIds = new Integer[0];
        } else {
            this.recoveringIds = ClusterViewDocument.csvToIntegerArray((String)obj2);
        }
        Object obj3 = doc.get(INACTIVE_KEY);
        if (obj3 == null || !(obj3 instanceof String)) {
            logger.trace("<init>: {} : {}", (Object)INACTIVE_KEY, obj3);
            this.inactiveIds = new Integer[0];
        } else {
            this.inactiveIds = ClusterViewDocument.csvToIntegerArray((String)obj3);
        }
        Object obj4 = doc.get(CLUSTER_VIEW_HISTORY_KEY);
        if (obj4 == null || !(obj4 instanceof Map)) {
            logger.trace("<init> viewHistory is null");
            this.viewHistory = null;
        } else {
            this.viewHistory = (Map)obj4;
        }
    }

    Set<Integer> getActiveIds() {
        return new HashSet<Integer>(Arrays.asList(this.activeIds));
    }

    Set<Integer> getRecoveringIds() {
        return new HashSet<Integer>(Arrays.asList(this.recoveringIds));
    }

    Set<Integer> getInactiveIds() {
        return new HashSet<Integer>(Arrays.asList(this.inactiveIds));
    }

    Map<Object, String> getHistory() {
        return this.viewHistory;
    }

    public String toString() {
        return "a ClusterView[valid=" + this.isValid() + ", viewSeqNum=" + this.viewSeqNum + ", activeIds=" + ClusterViewDocument.arrayToCsv(this.activeIds) + ", recoveringIds=" + ClusterViewDocument.arrayToCsv(this.recoveringIds) + ", inactiveIds=" + ClusterViewDocument.arrayToCsv(this.inactiveIds) + "]";
    }

    boolean isValid() {
        return this.viewSeqNum >= 0L && this.activeIds != null && this.activeIds.length > 0;
    }

    String getCreatedAt() {
        return this.createdAt;
    }

    long getCreatedBy() {
        return this.createdBy;
    }

    long getViewSeqNum() {
        return this.viewSeqNum;
    }

    private boolean matches(Set<Integer> activeIds, Set<Integer> recoveringIds, Set<Integer> inactiveIds) {
        if (!ClusterViewDocument.matches(this.activeIds, activeIds)) {
            return false;
        }
        if (!ClusterViewDocument.matches(this.recoveringIds, recoveringIds)) {
            return false;
        }
        return ClusterViewDocument.matches(this.inactiveIds, inactiveIds);
    }
}

