/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.lock.LockDeprecation;
import org.apache.jackrabbit.oak.jcr.lock.LockImpl;
import org.apache.jackrabbit.oak.jcr.lock.LockOperation;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;

public class LockManagerImpl
implements LockManager {
    private final SessionContext sessionContext;
    private final SessionDelegate delegate;

    public LockManagerImpl(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.delegate = sessionContext.getSessionDelegate();
    }

    @NotNull
    public String[] getLockTokens() throws RepositoryException {
        return this.delegate.perform(new SessionOperation<String[]>("getLockTokens"){

            @Override
            @NotNull
            public String[] perform() {
                Set<String> tokens = LockManagerImpl.this.sessionContext.getOpenScopedLocks();
                return tokens.toArray(new String[tokens.size()]);
            }
        });
    }

    public void addLockToken(final String lockToken) throws RepositoryException {
        LockDeprecation.handleCall("addLockToken");
        try {
            this.delegate.performVoid((SessionOperation<Void>)new LockOperation<Void>(this.sessionContext, lockToken, "addLockToken"){

                @Override
                protected void performVoid(@NotNull NodeDelegate node) throws LockException {
                    if (!node.holdsLock(false)) {
                        throw new LockException("Invalid lock token: " + lockToken);
                    }
                    String token = node.getPath();
                    LockManagerImpl.this.sessionContext.getOpenScopedLocks().add(token);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new LockException("Invalid lock token: " + lockToken);
        }
    }

    public void removeLockToken(final String lockToken) throws RepositoryException {
        LockDeprecation.handleCall("removeLockToken");
        if (!this.delegate.perform(new SessionOperation<Boolean>("removeLockToken"){

            @Override
            @NotNull
            public Boolean perform() {
                return LockManagerImpl.this.sessionContext.getOpenScopedLocks().remove(lockToken);
            }
        }).booleanValue()) {
            throw new LockException("Lock token " + lockToken + " is not held by this session");
        }
    }

    public boolean isLocked(String absPath) throws RepositoryException {
        return this.delegate.perform(new LockOperation<Boolean>(this.sessionContext, absPath, "isLocked"){

            @Override
            @NotNull
            protected Boolean perform(@NotNull NodeDelegate node) {
                return node.isLocked();
            }
        });
    }

    public boolean holdsLock(String absPath) throws RepositoryException {
        return this.delegate.perform(new LockOperation<Boolean>(this.sessionContext, absPath, "holdsLock"){

            @Override
            @NotNull
            protected Boolean perform(@NotNull NodeDelegate node) {
                return node.holdsLock(false);
            }
        });
    }

    @NotNull
    public Lock getLock(final String absPath) throws RepositoryException {
        NodeDelegate lock = this.delegate.perform(new LockOperation<NodeDelegate>(this.sessionContext, absPath, "getLock"){

            @Override
            @NotNull
            protected NodeDelegate perform(@NotNull NodeDelegate node) throws LockException {
                NodeDelegate lock = node.getLock();
                if (lock == null) {
                    throw new LockException("Node " + absPath + " is not locked");
                }
                return lock;
            }
        });
        return new LockImpl(this.sessionContext, lock);
    }

    @NotNull
    public Lock lock(String absPath, final boolean isDeep, final boolean isSessionScoped, long timeoutHint, String ownerInfo) throws RepositoryException {
        LockDeprecation.handleCall("lock");
        return new LockImpl(this.sessionContext, this.delegate.perform(new LockOperation<NodeDelegate>(this.sessionContext, absPath, "lock"){

            @Override
            @NotNull
            protected NodeDelegate perform(@NotNull NodeDelegate node) throws RepositoryException {
                if (node.getStatus() != Tree.Status.UNCHANGED) {
                    throw new InvalidItemStateException("Unable to lock a node with pending changes");
                }
                node.lock(isDeep);
                String path = node.getPath();
                if (isSessionScoped) {
                    LockManagerImpl.this.sessionContext.getSessionScopedLocks().add(path);
                } else {
                    LockManagerImpl.this.sessionContext.getOpenScopedLocks().add(path);
                }
                this.session.refresh(true);
                return node;
            }
        }));
    }

    public void unlock(String absPath) throws RepositoryException {
        LockDeprecation.handleCall("unlock");
        this.delegate.performVoid((SessionOperation<Void>)new LockOperation<Void>(this.sessionContext, absPath, "unlock"){

            @Override
            protected void performVoid(@NotNull NodeDelegate node) throws RepositoryException {
                String path = node.getPath();
                if (!LockManagerImpl.this.canUnlock(node)) {
                    throw new LockException("Not an owner of the lock " + path);
                }
                node.unlock();
                LockManagerImpl.this.sessionContext.getSessionScopedLocks().remove(path);
                LockManagerImpl.this.sessionContext.getOpenScopedLocks().remove(path);
                this.session.refresh(true);
            }
        });
    }

    public boolean canUnlock(NodeDelegate node) {
        String path = node.getPath();
        if (this.sessionContext.getSessionScopedLocks().contains(path) || this.sessionContext.getOpenScopedLocks().contains(path)) {
            return true;
        }
        if (this.sessionContext.getAttributes().get("oak.relaxed-locking") == Boolean.TRUE) {
            String user = this.sessionContext.getSessionDelegate().getAuthInfo().getUserID();
            return node.isLockOwner(user) || this.isAdmin(this.sessionContext, user);
        }
        return false;
    }

    private boolean isAdmin(SessionContext sessionContext, String user) {
        try {
            Authorizable a = sessionContext.getUserManager().getAuthorizable(user);
            if (a != null && !a.isGroup()) {
                return ((User)a).isAdmin();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }
}

