/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class PropertyPredicate
implements java.util.function.Predicate<NodeState>,
Predicate<NodeState> {
    private final String name;
    private final java.util.function.Predicate<PropertyState> propertyPredicate;

    public PropertyPredicate(@NotNull String name, @NotNull java.util.function.Predicate<PropertyState> propertyPredicate) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.propertyPredicate = (java.util.function.Predicate)Preconditions.checkNotNull(propertyPredicate);
    }

    @Override
    public boolean test(NodeState node) {
        PropertyState property = node.getProperty(this.name);
        return property != null && this.propertyPredicate.test(property);
    }

    @Deprecated(since="1.26.0", forRemoval=true)
    public boolean apply(NodeState node) {
        GuavaDeprecation.handleCall("OAK-8874");
        return this.test(node);
    }
}

