/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public final class CommunityComponentSettings {
    public static final String COMPONENT_NAME = "community";
    public static final String SETTINGS_PATH = "org.silverpeas.components.community.settings.communitySettings";
    public static final String MESSAGES_PATH = "org.silverpeas.components.community.multilang.communityBundle";

    private CommunityComponentSettings() {
    }

    public static LocalizationBundle getMessagesIn(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public static SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)SETTINGS_PATH);
    }

    public static List<String> getLeaveReasons(String language) {
        return Stream.of(CommunityComponentSettings.getMessagesIn(language).getString("community.membership.leaving.reasons").split(";")).map(String::trim).collect(Collectors.toList());
    }
}

