/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.notification;

import java.util.Date;
import org.owasp.encoder.Encode;
import org.silverpeas.components.blog.model.Category;
import org.silverpeas.components.blog.model.PostDetail;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

abstract class AbstractBlogUserNotification
extends AbstractTemplateUserNotificationBuilder<PostDetail> {
    private final User user;

    AbstractBlogUserNotification(PostDetail postDetail, User user) {
        super((Object)postDetail);
        this.user = user;
    }

    protected void performTemplateData(String language, PostDetail resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, StringUtil.defaultStringIfNotDefined((String)this.getTitle(language), (String)this.getTitle()), "");
        template.setAttribute("blog", (Object)resource);
        template.setAttribute("blogName", (Object)Encode.forHtml((String)resource.getPublication().getName(language)));
        template.setAttribute("blogDate", (Object)DateUtil.getOutputDate((Date)resource.getDateEvent(), (String)language));
        Category categorie = resource.getCategory();
        String categorieName = null;
        if (categorie != null) {
            categorieName = categorie.getName(language);
        }
        template.setAttribute("blogCategorie", (Object)categorieName);
        template.setAttribute("senderName", (Object)(this.user != null ? this.user.getDisplayedName() : ""));
    }

    protected void performNotificationResource(String language, PostDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(false);
        notificationResourceData.setResourceName(resource.getPublication().getName(language));
    }

    protected void perform(PostDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getTemplatePath() {
        return "blog";
    }

    protected String getComponentInstanceId() {
        return ((PostDetail)this.getResource()).getComponentInstanceId();
    }

    protected String getSender() {
        return this.user.getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.blog.multilang.blogBundle";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "blog.notifPostLinkLabel";
    }
}

