/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.principal.EveryoneFilter;
import org.apache.jackrabbit.oak.security.user.AbstractGroupPrincipal;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.CacheValidatorProvider;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.SystemUserPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserProvider;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserPrincipalProvider
implements PrincipalProvider {
    private static final Logger log = LoggerFactory.getLogger(UserPrincipalProvider.class);
    static final String PARAM_CACHE_EXPIRATION = "cacheExpiration";
    static final long EXPIRATION_NO_CACHE = 0L;
    private static final long MEMBERSHIP_THRESHOLD = 0L;
    private final Root root;
    private final UserConfiguration config;
    private final NamePathMapper namePathMapper;
    private final UserProvider userProvider;
    private final MembershipProvider membershipProvider;
    private final long expiration;
    private final boolean cacheEnabled;

    UserPrincipalProvider(@NotNull Root root, @NotNull UserConfiguration userConfiguration, @NotNull NamePathMapper namePathMapper) {
        this.root = root;
        this.config = userConfiguration;
        this.namePathMapper = namePathMapper;
        this.userProvider = new UserProvider(root, this.config.getParameters());
        this.membershipProvider = new MembershipProvider(root, this.config.getParameters());
        this.expiration = (Long)this.config.getParameters().getConfigValue(PARAM_CACHE_EXPIRATION, (Object)0L);
        this.cacheEnabled = this.expiration > 0L && root.getContentSession().getAuthInfo().getPrincipals().contains(SystemPrincipal.INSTANCE);
    }

    public Principal getPrincipal(@NotNull String principalName) {
        Tree authorizableTree = this.userProvider.getAuthorizableByPrincipal((Principal)new PrincipalImpl(principalName));
        Principal principal = this.createPrincipal(authorizableTree);
        if (principal == null) {
            return "everyone".equals(principalName) ? EveryonePrincipal.getInstance() : null;
        }
        return principal;
    }

    @Nullable
    public ItemBasedPrincipal getItemBasedPrincipal(@NotNull String principalOakPath) {
        Tree authorizableTree = this.userProvider.getAuthorizableByPath(principalOakPath);
        Principal principal = this.createPrincipal(authorizableTree);
        if (principal instanceof ItemBasedPrincipal) {
            return (ItemBasedPrincipal)principal;
        }
        return null;
    }

    @NotNull
    public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        Tree tree = this.getAuthorizableTree(principal);
        if (tree == null) {
            return Collections.emptySet();
        }
        return this.getGroupMembership(tree);
    }

    @NotNull
    public Set<? extends Principal> getPrincipals(@NotNull String userID) {
        Principal userPrincipal;
        HashSet<Principal> principals = new HashSet<Principal>();
        Tree tree = this.userProvider.getAuthorizable(userID);
        if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER) && (userPrincipal = this.createUserPrincipal(userID, tree)) != null) {
            principals.add(userPrincipal);
            principals.addAll(this.getGroupMembership(tree));
        }
        return principals;
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        return this.findPrincipals(nameHint, false, searchType, 0L, -1L);
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, boolean fullText, int searchType, long offset, long limit) {
        if (offset < 0L) {
            offset = 0L;
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        try {
            String lookupClause = "";
            if (nameHint != null && !nameHint.isEmpty()) {
                lookupClause = fullText ? String.format("[jcr:contains(.,'%s')]", UserPrincipalProvider.buildSearchPatternFT(nameHint)) : String.format("[jcr:like(@rep:principalName,'%s')]", UserPrincipalProvider.buildSearchPatternContains(nameHint));
            }
            AuthorizableType type = AuthorizableType.getType((int)searchType);
            StringBuilder statement = new StringBuilder().append(QueryUtil.getSearchRoot(type, this.config.getParameters())).append("//element(*,").append(QueryUtil.getNodeTypeName(type)).append(')').append(lookupClause).append(" order by @rep:principalName");
            Result result = this.root.getQueryEngine().executeQuery(statement.toString(), "xpath", limit, offset, QueryEngine.NO_BINDINGS, this.namePathMapper.getSessionLocalMappings());
            UnmodifiableIterator principals = Iterators.filter((Iterator)Iterators.transform(result.getRows().iterator(), (Function)new ResultRowToPrincipal()), (Predicate)Predicates.notNull());
            return EveryoneFilter.filter((Iterator<Principal>)principals, nameHint, searchType, offset, limit);
        }
        catch (ParseException e) {
            log.debug(e.getMessage());
            return Collections.emptyIterator();
        }
    }

    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @Nullable
    private Tree getAuthorizableTree(@NotNull Principal principal) {
        return this.userProvider.getAuthorizableByPrincipal(principal);
    }

    @Nullable
    private Principal createPrincipal(@Nullable Tree authorizableTree) {
        if (authorizableTree != null) {
            AuthorizableType type = UserUtil.getType((Tree)authorizableTree);
            if (AuthorizableType.GROUP == type) {
                return this.createGroupPrincipal(authorizableTree);
            }
            if (AuthorizableType.USER == type) {
                return this.createUserPrincipal(UserUtil.getAuthorizableId((Tree)authorizableTree, (AuthorizableType)AuthorizableType.USER), authorizableTree);
            }
        }
        return null;
    }

    @Nullable
    private Principal createUserPrincipal(@NotNull String id, @NotNull Tree userTree) {
        String principalName = UserPrincipalProvider.getPrincipalName(userTree);
        if (principalName == null) {
            return null;
        }
        if (UserUtil.isSystemUser((Tree)userTree)) {
            return new SystemUserPrincipalImpl(principalName, userTree, this.namePathMapper);
        }
        if (UserUtil.isAdmin((ConfigurationParameters)this.config.getParameters(), (String)id)) {
            return new AdminPrincipalImpl(principalName, userTree, this.namePathMapper);
        }
        return new TreeBasedPrincipal(principalName, userTree, this.namePathMapper);
    }

    @Nullable
    private Principal createGroupPrincipal(@NotNull Tree groupTree) {
        String principalName = UserPrincipalProvider.getPrincipalName(groupTree);
        if (principalName == null) {
            return null;
        }
        return new GroupPrincipalImpl(principalName, groupTree.getPath(), this.namePathMapper, this.root, this.config);
    }

    @Nullable
    private static String getPrincipalName(@NotNull Tree tree) {
        PropertyState principalName = tree.getProperty("rep:principalName");
        if (principalName != null) {
            return (String)principalName.getValue(Type.STRING);
        }
        String msg = "Authorizable without principal name " + UserUtil.getAuthorizableId((Tree)tree);
        log.warn(msg);
        return null;
    }

    @NotNull
    private Set<Principal> getGroupMembership(@NotNull Tree authorizableTree) {
        HashSet<Principal> groupPrincipals = new HashSet<Principal>();
        boolean doCache = this.cacheEnabled && UserUtil.isType((Tree)authorizableTree, (AuthorizableType)AuthorizableType.USER);
        boolean doLoad = true;
        if (doCache) {
            doLoad = this.readGroupsFromCache(authorizableTree, groupPrincipals);
        }
        if (doLoad) {
            Iterator<Tree> groupTrees = this.membershipProvider.getMembership(authorizableTree, true);
            while (groupTrees.hasNext()) {
                Principal gr;
                Tree groupTree = groupTrees.next();
                if (!UserUtil.isType((Tree)groupTree, (AuthorizableType)AuthorizableType.GROUP) || (gr = this.createGroupPrincipal(groupTree)) == null) continue;
                groupPrincipals.add(gr);
            }
            if (doCache) {
                this.cacheGroups(authorizableTree, groupPrincipals);
            }
        }
        groupPrincipals.add((Principal)EveryonePrincipal.getInstance());
        return groupPrincipals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheGroups(@NotNull Tree authorizableNode, @NotNull Set<Principal> groupPrincipals) {
        try {
            this.root.refresh();
            Tree cache = authorizableNode.getChild("rep:cache");
            if (!cache.exists()) {
                if ((long)groupPrincipals.size() <= 0L) {
                    log.debug("Omit cache creation for user without group membership at {}", (Object)authorizableNode.getPath());
                    return;
                }
                log.debug("Create new group membership cache at {}", (Object)authorizableNode.getPath());
                cache = TreeUtil.addChild((Tree)authorizableNode, (String)"rep:cache", (String)"rep:Cache");
            }
            cache.setProperty("rep:expiration", (Object)LongUtils.calculateExpirationTime((long)this.expiration));
            String value = groupPrincipals.isEmpty() ? "" : Joiner.on((String)",").join(Iterables.transform(groupPrincipals, input -> Text.escape((String)input.getName())));
            cache.setProperty("rep:groupPrincipalNames", (Object)value);
            this.root.commit(CacheValidatorProvider.asCommitAttributes());
            log.debug("Cached group membership at {}", (Object)authorizableNode.getPath());
        }
        catch (AccessDeniedException | CommitFailedException e) {
            log.debug("Failed to cache group membership: {}", (Object)e.getMessage());
        }
        finally {
            this.root.refresh();
        }
    }

    private boolean readGroupsFromCache(@NotNull Tree authorizableNode, @NotNull Set<Principal> groups) {
        Tree principalCache = authorizableNode.getChild("rep:cache");
        if (!principalCache.exists()) {
            log.debug("No group cache at {}", (Object)authorizableNode.getPath());
            return true;
        }
        if (UserPrincipalProvider.isValidCache(principalCache)) {
            log.debug("Reading group membership at {}", (Object)authorizableNode.getPath());
            String str = TreeUtil.getString((Tree)principalCache, (String)"rep:groupPrincipalNames");
            if (Strings.isNullOrEmpty((String)str)) {
                return false;
            }
            for (String s : Text.explode((String)str, (int)44)) {
                String name = Text.unescape((String)s);
                groups.add((Principal)((Object)new CachedGroupPrincipal(name, this.namePathMapper, this.root, this.config)));
            }
            return false;
        }
        log.debug("Expired group cache for {}", (Object)authorizableNode.getPath());
        return true;
    }

    private static boolean isValidCache(Tree principalCache) {
        long expirationTime = TreeUtil.getLong((Tree)principalCache, (String)"rep:expiration", (long)0L);
        long now = new Date().getTime();
        return expirationTime > 0L && now < expirationTime;
    }

    private static String buildSearchPatternContains(@NotNull String nameHint) {
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        sb.append(nameHint.replace("%", "\\%").replace("_", "\\_"));
        sb.append('%');
        return sb.toString();
    }

    private static String buildSearchPatternFT(@NotNull String nameHint) {
        if (nameHint.contains("*")) {
            return QueryUtil.escapeForQuery(nameHint);
        }
        return QueryUtil.escapeForQuery(nameHint) + "*";
    }

    private static final class CachedGroupPrincipal
    extends BaseGroupPrincipal {
        private Group group;

        CachedGroupPrincipal(@NotNull String principalName, @NotNull NamePathMapper namePathMapper, @NotNull Root root, @NotNull UserConfiguration config) {
            super(principalName, "", namePathMapper, root, config);
        }

        @Override
        @NotNull
        String getOakPath() throws RepositoryException {
            String oakPath = this.getNamePathMapper().getOakPath(this.getPath());
            if (oakPath == null) {
                throw new RepositoryException("Failed to retrieve path of group principal " + this.getName());
            }
            return oakPath;
        }

        @Override
        @NotNull
        public String getPath() throws RepositoryException {
            Group gr = this.getGroup();
            if (gr == null) {
                throw new RepositoryException("Failed to retrieve path of group principal " + this.getName());
            }
            return gr.getPath();
        }

        @Override
        @Nullable
        Group getGroup() throws RepositoryException {
            Authorizable authorizable;
            if (this.group == null && (authorizable = this.getUserManager().getAuthorizable((Principal)new PrincipalImpl(this.getName()))) != null && authorizable.isGroup()) {
                this.group = (Group)authorizable;
            }
            return this.group;
        }
    }

    private static final class GroupPrincipalImpl
    extends BaseGroupPrincipal {
        private Group group;

        GroupPrincipalImpl(@NotNull String principalName, @NotNull String groupPath, @NotNull NamePathMapper namePathMapper, @NotNull Root root, @NotNull UserConfiguration config) {
            super(principalName, groupPath, namePathMapper, root, config);
        }

        @Override
        @Nullable
        Group getGroup() throws RepositoryException {
            Authorizable authorizable;
            if (this.group == null && (authorizable = this.getUserManager().getAuthorizable((Principal)((Object)this))) != null && authorizable.isGroup()) {
                this.group = (Group)authorizable;
            }
            return this.group;
        }
    }

    private static abstract class BaseGroupPrincipal
    extends AbstractGroupPrincipal {
        private final Root root;
        private final UserConfiguration config;
        private UserManager userManager;

        BaseGroupPrincipal(@NotNull String principalName, @NotNull String groupPath, @NotNull NamePathMapper namePathMapper, @NotNull Root root, @NotNull UserConfiguration config) {
            super(principalName, groupPath, namePathMapper);
            this.root = root;
            this.config = config;
        }

        @Override
        @NotNull
        UserManager getUserManager() {
            if (this.userManager == null) {
                this.userManager = this.config.getUserManager(this.root, this.getNamePathMapper());
            }
            return this.userManager;
        }

        @Override
        boolean isEveryone() {
            return "everyone".equals(this.getName());
        }

        @Override
        boolean isMember(@NotNull Authorizable authorizable) throws RepositoryException {
            Group g = this.getGroup();
            return g != null && g.isMember(authorizable);
        }

        @Override
        @NotNull
        Iterator<Authorizable> getMembers() throws RepositoryException {
            Group g = this.getGroup();
            return g == null ? Collections.emptyIterator() : g.getMembers();
        }

        @Nullable
        abstract Group getGroup() throws RepositoryException;
    }

    private final class ResultRowToPrincipal
    implements Function<ResultRow, Principal> {
        private ResultRowToPrincipal() {
        }

        public Principal apply(ResultRow resultRow) {
            return UserPrincipalProvider.this.createPrincipal(resultRow.getTree(null));
        }
    }
}

