/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool.iotrace;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.segment.tool.iotrace.Trace;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class RandomAccessTrace
implements Trace {
    public static final String CONTEXT_SPEC = "path";
    @NotNull
    private final Random rnd;
    private final int count;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final Consumer<List<String>> context;

    public RandomAccessTrace(@NotNull List<String> paths, long seed, int count, @NotNull Consumer<List<String>> context) {
        this.rnd = new Random(seed);
        this.count = count;
        this.paths = paths;
        this.context = context;
    }

    @Override
    public void run(@NotNull NodeState root) {
        if (!this.paths.isEmpty()) {
            for (int c = 0; c < this.count; ++c) {
                String path = this.paths.get(this.rnd.nextInt(this.paths.size()));
                this.context.accept((List<String>)ImmutableList.of((Object)path));
                NodeState node = root;
                for (String name : PathUtils.elements((String)PathUtils.getParentPath((String)path))) {
                    node = node.getChildNode(name);
                }
                String name = PathUtils.getName((String)path);
                if (node.hasProperty(name)) {
                    PropertyState property = Objects.requireNonNull(node.getProperty(name));
                    if (property.isArray()) {
                        for (int k = 0; k < property.count(); ++k) {
                            property.getValue(Type.STRING, k);
                        }
                        continue;
                    }
                    property.getValue(Type.STRING);
                    continue;
                }
                node.getChildNode(name);
            }
        }
    }
}

