/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.jackrabbit.oak.segment.standby.server.AddressResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InetAddressResolver
implements AddressResolver {
    private static final Logger log = LoggerFactory.getLogger(InetAddressResolver.class);

    InetAddressResolver() {
    }

    @Override
    public InetAddress resolve(String host) {
        InetAddress address;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            log.warn("Unable to resolve address or invalid IP literal " + host, (Throwable)e);
            address = null;
        }
        return address;
    }
}

