/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.CommitNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class JournalNode
extends AbstractNode {
    private final Proc.Backend backend;

    JournalNode(Proc.Backend backend) {
        this.backend = backend;
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.backend.commitExists(name);
    }

    @Override
    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        if (this.backend.commitExists(name)) {
            return new CommitNode(this.backend, name);
        }
        return EmptyNodeState.MISSING_NODE;
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        ArrayList<MemoryChildNodeEntry> entries = new ArrayList<MemoryChildNodeEntry>();
        for (String handle : this.backend.getCommitHandles()) {
            entries.add(new MemoryChildNodeEntry(handle, (NodeState)new CommitNode(this.backend, handle)));
        }
        return entries;
    }
}

