/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.guava.common.cache.RemovalNotification;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.jetbrains.annotations.NotNull;

public abstract class SegmentCache {
    public static final int DEFAULT_SEGMENT_CACHE_MB = 256;
    private static final String NAME = "Segment Cache";

    @NotNull
    public static SegmentCache newSegmentCache(long cacheSizeMB) {
        if (cacheSizeMB > 0L) {
            return new NonEmptyCache(cacheSizeMB);
        }
        return new EmptyCache();
    }

    @NotNull
    public abstract Segment getSegment(@NotNull SegmentId var1, @NotNull Callable<Segment> var2) throws ExecutionException;

    public abstract void putSegment(@NotNull Segment var1);

    public abstract void clear();

    @NotNull
    public abstract AbstractCacheStats getCacheStats();

    public abstract void recordHit();

    private static class Stats
    extends AbstractCacheStats {
        private final long maximumWeight;
        @NotNull
        private final Supplier<Long> elementCount;
        @NotNull
        final AtomicLong currentWeight = new AtomicLong();
        @NotNull
        final AtomicLong loadSuccessCount = new AtomicLong();
        @NotNull
        final AtomicInteger loadExceptionCount = new AtomicInteger();
        @NotNull
        final AtomicLong loadTime = new AtomicLong();
        @NotNull
        final AtomicLong evictionCount = new AtomicLong();
        @NotNull
        final AtomicLong hitCount = new AtomicLong();
        @NotNull
        final AtomicLong missCount = new AtomicLong();

        protected Stats(@NotNull String name, long maximumWeight, @NotNull Supplier<Long> elementCount) {
            super(name);
            this.maximumWeight = maximumWeight;
            this.elementCount = (Supplier)Preconditions.checkNotNull(elementCount);
        }

        protected CacheStats getCurrentStats() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.loadSuccessCount.get(), (long)this.loadExceptionCount.get(), this.loadTime.get(), this.evictionCount.get());
        }

        public long getElementCount() {
            return this.elementCount.get();
        }

        public long getMaxTotalWeight() {
            return this.maximumWeight;
        }

        public long estimateCurrentWeight() {
            return this.currentWeight.get();
        }
    }

    private static class EmptyCache
    extends SegmentCache {
        private final Stats stats = new Stats("Segment Cache", 0L, () -> 0L);

        private EmptyCache() {
        }

        @Override
        @NotNull
        public Segment getSegment(@NotNull SegmentId id, @NotNull Callable<Segment> loader) throws ExecutionException {
            long t0 = System.nanoTime();
            try {
                this.stats.missCount.incrementAndGet();
                Segment segment = loader.call();
                this.stats.loadSuccessCount.incrementAndGet();
                Segment segment2 = segment;
                return segment2;
            }
            catch (Exception e) {
                this.stats.loadExceptionCount.incrementAndGet();
                throw new ExecutionException(e);
            }
            finally {
                this.stats.loadTime.addAndGet(System.nanoTime() - t0);
            }
        }

        @Override
        public void putSegment(@NotNull Segment segment) {
            segment.getSegmentId().unloaded();
        }

        @Override
        public void clear() {
        }

        @Override
        @NotNull
        public AbstractCacheStats getCacheStats() {
            return this.stats;
        }

        @Override
        public void recordHit() {
            this.stats.hitCount.incrementAndGet();
        }
    }

    private static class NonEmptyCache
    extends SegmentCache {
        @NotNull
        private final Cache<SegmentId, Segment> cache;
        @NotNull
        private final Stats stats;

        private NonEmptyCache(long cacheSizeMB) {
            long maximumWeight = cacheSizeMB * 1024L * 1024L;
            this.cache = CacheBuilder.newBuilder().concurrencyLevel(16).maximumWeight(maximumWeight).weigher((Weigher)new CacheWeights.SegmentCacheWeigher()).removalListener(this::onRemove).build();
            this.stats = new Stats(SegmentCache.NAME, maximumWeight, () -> this.cache.size());
        }

        private void onRemove(@NotNull RemovalNotification<SegmentId, Segment> notification) {
            this.stats.evictionCount.incrementAndGet();
            if (notification.getValue() != null) {
                this.stats.currentWeight.addAndGet(-CacheWeights.segmentWeight((Segment)notification.getValue()));
            }
            if (notification.getKey() != null) {
                ((SegmentId)notification.getKey()).unloaded();
            }
        }

        @Override
        @NotNull
        public Segment getSegment(@NotNull SegmentId id, @NotNull Callable<Segment> loader) throws ExecutionException {
            if (id.isDataSegmentId()) {
                return (Segment)this.cache.get((Object)id, () -> {
                    try {
                        long t0 = System.nanoTime();
                        Segment segment = (Segment)loader.call();
                        this.stats.loadSuccessCount.incrementAndGet();
                        this.stats.loadTime.addAndGet(System.nanoTime() - t0);
                        this.stats.missCount.incrementAndGet();
                        this.stats.currentWeight.addAndGet(CacheWeights.segmentWeight(segment));
                        id.loaded(segment);
                        return segment;
                    }
                    catch (Exception e) {
                        this.stats.loadExceptionCount.incrementAndGet();
                        throw e;
                    }
                });
            }
            try {
                return loader.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public void putSegment(@NotNull Segment segment) {
            SegmentId id = segment.getSegmentId();
            if (id.isDataSegmentId()) {
                id.loaded(segment);
                this.stats.currentWeight.addAndGet(CacheWeights.segmentWeight(segment));
                this.cache.put((Object)id, (Object)segment);
            }
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
        }

        @Override
        @NotNull
        public AbstractCacheStats getCacheStats() {
            return this.stats;
        }

        @Override
        public void recordHit() {
            this.stats.hitCount.incrementAndGet();
        }
    }
}

