/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

public class BooleanPropertyState
extends SinglePropertyState<Boolean> {
    private final boolean value;

    public BooleanPropertyState(@NotNull String name, boolean value) {
        super(name);
        this.value = value;
    }

    public static PropertyState booleanProperty(@NotNull String name, boolean value) {
        return new BooleanPropertyState(name, value);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    public Type<?> getType() {
        return Type.BOOLEAN;
    }
}

