/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.segment.file.LocalGCJournalFile;
import org.apache.jackrabbit.oak.segment.file.LocalManifestFile;
import org.apache.jackrabbit.oak.segment.file.tar.LocalJournalFile;
import org.apache.jackrabbit.oak.segment.file.tar.SegmentTarManager;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;

public class TarPersistence
implements SegmentNodeStorePersistence {
    private static final String LOCK_FILE_NAME = "repo.lock";
    private static final String GC_JOURNAL = "gc.log";
    private static final String MANIFEST_FILE_NAME = "manifest";
    private static final String JOURNAL_FILE_NAME = "journal.log";
    private final File directory;
    private final File journal;

    public TarPersistence(File directory) {
        this(directory, new File(directory, JOURNAL_FILE_NAME));
    }

    public TarPersistence(File directory, File journal) {
        this.directory = directory;
        this.journal = journal;
    }

    @Override
    public SegmentArchiveManager createArchiveManager(boolean memoryMapping, boolean offHeapAccess, IOMonitor ioMonitor, FileStoreMonitor fileStoreMonitor, RemoteStoreMonitor remoteStoreMonitor) {
        return new SegmentTarManager(this.directory, fileStoreMonitor, ioMonitor, memoryMapping, offHeapAccess);
    }

    @Override
    public boolean segmentFilesExist() {
        Collection entries = FileUtils.listFiles((File)this.directory, (String[])new String[]{"tar"}, (boolean)false);
        return !entries.isEmpty();
    }

    @Override
    public JournalFile getJournalFile() {
        return new LocalJournalFile(this.journal);
    }

    @Override
    public GCJournalFile getGCJournalFile() {
        return new LocalGCJournalFile(this.directory, GC_JOURNAL);
    }

    @Override
    public ManifestFile getManifestFile() {
        return new LocalManifestFile(this.directory, MANIFEST_FILE_NAME);
    }

    @Override
    public RepositoryLock lockRepository() throws IOException {
        RandomAccessFile lockFile = new RandomAccessFile(new File(this.directory, LOCK_FILE_NAME), "rw");
        try {
            FileLock lock = lockFile.getChannel().lock();
            return () -> {
                lock.release();
                lockFile.close();
            };
        }
        catch (OverlappingFileLockException ex) {
            throw new IllegalStateException(this.directory.getAbsolutePath() + " is in use by another store.", ex);
        }
    }
}

