/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.Deque;
import java.util.Iterator;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Queues;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.AbstractCursor;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.index.IndexRowImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TraversingCursor
extends AbstractCursor {
    private static final Logger LOG = LoggerFactory.getLogger(TraversingCursor.class);
    private final Filter filter;
    private final Deque<Iterator<? extends ChildNodeEntry>> nodeIterators = Queues.newArrayDeque();
    private String parentPath;
    private String currentPath;
    private long readCount;
    private boolean init;
    private boolean closed;
    private final QueryLimits settings;

    public TraversingCursor(Filter filter, NodeState rootState) {
        this.filter = filter;
        this.settings = filter.getQueryLimits();
        String path = filter.getPath();
        this.parentPath = null;
        this.currentPath = "/";
        NodeState parent = null;
        NodeState node = rootState;
        if (filter.containsNativeConstraint()) {
            return;
        }
        if (filter.isAlwaysFalse()) {
            return;
        }
        Filter.PropertyRestriction facetRestriction = filter.getPropertyRestriction("rep:facet");
        if (facetRestriction != null) {
            throw new IllegalArgumentException(facetRestriction + " can't be evaluated by traversal");
        }
        if (!path.equals("/")) {
            for (String name : path.substring(1).split("/")) {
                this.parentPath = this.currentPath;
                this.currentPath = PathUtils.concat((String)this.parentPath, (String)name);
                parent = node;
                node = parent.getChildNode(name);
            }
            if (!node.exists()) {
                return;
            }
        }
        Filter.PathRestriction restriction = filter.getPathRestriction();
        switch (restriction) {
            case NO_RESTRICTION: 
            case EXACT: 
            case ALL_CHILDREN: {
                this.nodeIterators.add((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry(this.currentPath, node)));
                this.parentPath = "";
                break;
            }
            case PARENT: {
                if (parent == null) break;
                this.nodeIterators.add((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry(this.parentPath, parent)));
                this.parentPath = "";
                break;
            }
            case DIRECT_CHILDREN: {
                this.nodeIterators.add(node.getChildNodeEntries().iterator());
                this.parentPath = this.currentPath;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown restriction: " + restriction);
            }
        }
    }

    public IndexRow next() {
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
        if (!this.init) {
            this.fetchNext();
            this.init = true;
        }
        IndexRowImpl result = new IndexRowImpl(this.currentPath);
        this.fetchNext();
        return result;
    }

    public boolean hasNext() {
        if (!this.closed && !this.init) {
            this.fetchNext();
            this.init = true;
        }
        return !this.closed;
    }

    private void fetchNext() {
        while (!this.nodeIterators.isEmpty()) {
            Iterator<? extends ChildNodeEntry> iterator = this.nodeIterators.getLast();
            if (iterator.hasNext()) {
                ChildNodeEntry entry = iterator.next();
                ++this.readCount;
                if (this.readCount % 1000L == 0L) {
                    FilterIterators.checkReadLimit(this.readCount, this.settings);
                    String caller = IndexUtils.getCaller(this.settings.getIgnoredClassNamesInCallTrace());
                    LOG.warn("Traversed {} nodes with filter {} called by {}; consider creating an index or changing the query", new Object[]{this.readCount, this.filter, caller});
                }
                NodeState node = entry.getNodeState();
                String name = entry.getName();
                if (NodeStateUtils.isHidden((String)name)) continue;
                this.currentPath = PathUtils.concat((String)this.parentPath, (String)name);
                Filter.PathRestriction r = this.filter.getPathRestriction();
                if (r == Filter.PathRestriction.ALL_CHILDREN || r == Filter.PathRestriction.NO_RESTRICTION) {
                    this.nodeIterators.addLast(node.getChildNodeEntries().iterator());
                    this.parentPath = this.currentPath;
                }
                return;
            }
            this.nodeIterators.removeLast();
            this.parentPath = PathUtils.getParentPath((String)this.parentPath);
        }
        this.currentPath = null;
        this.closed = true;
    }
}

