/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.UnicodeWhitespaceTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public class WhitespaceTokenizerFactory
extends TokenizerFactory {
    public static final String RULE_JAVA = "java";
    public static final String RULE_UNICODE = "unicode";
    private static final Collection<String> RULE_NAMES = Arrays.asList("java", "unicode");
    private final String rule;
    private final int maxTokenLen;

    public WhitespaceTokenizerFactory(Map<String, String> args) {
        super(args);
        this.rule = this.get(args, "rule", RULE_NAMES, RULE_JAVA);
        this.maxTokenLen = this.getInt(args, "maxTokenLen", 255);
        if (this.maxTokenLen > 0x100000 || this.maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + this.maxTokenLen);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        switch (this.rule) {
            case "java": {
                return new WhitespaceTokenizer(factory, this.maxTokenLen);
            }
            case "unicode": {
                return new UnicodeWhitespaceTokenizer(factory, this.maxTokenLen);
            }
        }
        throw new AssertionError();
    }
}

