/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.components.resourcesmanager.model.ResourceValidatorPk;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;

@Entity
@Table(name="sc_resources_managers")
@NamedQueries(value={@NamedQuery(name="resourceValidator.getResourceValidator", query="SELECT DISTINCT resourceValidator FROM ResourceValidator resourceValidator WHERE resourceValidator.id.managerId = :currentUserId AND resourceValidator.id.resourceId = :resourceId"), @NamedQuery(name="resourceValidator.deleteAllResourceValidatorsForComponentInstance", query="DELETE FROM ResourceValidator resourceValidator WHERE resourceValidator.resource IN (SELECT resource FROM Resource resource WHERE resource.instanceId = :instanceId)")})
public class ResourceValidator
extends BasicJpaEntity<ResourceValidator, ResourceValidatorPk>
implements Serializable {
    private static final long serialVersionUID = -7310087626487651284L;
    @ManyToOne
    @JoinColumn(name="resourceId", updatable=false, insertable=false, nullable=false, referencedColumnName="id")
    private Resource resource;

    public ResourceValidator() {
    }

    public ResourceValidator(long resourceId, long managerId) {
        this.setId(resourceId + ":" + managerId);
    }

    private String[] getStringIds() {
        return this.getId().split(":");
    }

    public long getManagerId() {
        return Long.parseLong(this.getStringIds()[1]);
    }

    public long getResourceId() {
        return Long.parseLong(this.getStringIds()[0]);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceValidator other = (ResourceValidator)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.getId() != null ? this.getId().hashCode() : 0);
        return hash;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        ((ResourceValidatorPk)this.getNativeId()).setResourceId(resource.getIdAsLong());
    }

    public String toString() {
        return "ResourceValidator{resourceValidatorPk=" + this.getId() + "}";
    }
}

