/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.notification;

import org.owasp.encoder.Encode;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.notification.AbstractQuickInfoUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractNewsUserNotification
extends AbstractQuickInfoUserNotification<News> {
    private final NotifAction action;

    public AbstractNewsUserNotification(News resource, NotifAction action) {
        super(resource);
        this.action = action;
    }

    protected void performTemplateData(String language, News resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("title", (Object)Encode.forHtml((String)resource.getTitle()));
        template.setAttribute("description", (Object)Encode.forHtml((String)resource.getDescription()));
        template.setAttribute("authorName", (Object)resource.getCreator().getDisplayedName());
        template.setAttribute("senderName", (Object)this.getSenderName());
    }

    protected void performNotificationResource(String language, News resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((News)((Object)this.getResource())).getComponentInstanceId();
    }

    protected String getSender() {
        String userId = ((News)((Object)this.getResource())).getUpdaterId();
        if (!StringUtil.isDefined((String)userId)) {
            userId = ((News)((Object)this.getResource())).getCreatorId();
        }
        return userId;
    }
}

