/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import org.silverpeas.components.gallery.Watermark;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.io.media.video.ThumbnailPeriod;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public final class GalleryComponentSettings {
    public static final String COMPONENT_NAME = "gallery";
    public static final String SETTINGS_PATH = "org.silverpeas.gallery.settings.gallerySettings";
    public static final String MESSAGES_PATH = "org.silverpeas.gallery.multilang.galleryBundle";
    public static final String ICONS_PATH = "org.silverpeas.gallery.settings.galleryIcons";
    private static final int DEFAULT_NBMEDIAS_PER_PAGE = 15;

    private GalleryComponentSettings() {
    }

    public static LocalizationBundle getMessagesIn(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public static SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)SETTINGS_PATH);
    }

    public static LocalizationBundle getIcons() {
        return ResourceLocator.getLocalizationBundle((String)ICONS_PATH);
    }

    public static int getNbMediaDisplayedPerPage() {
        return 15;
    }

    public static boolean isDragAndDropEnabled(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentInstanceId, "dragAndDrop"));
    }

    public static boolean isPdcEnabled(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentInstanceId, "usePdc"));
    }

    public static boolean isViewMetadataEnabled(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentInstanceId, "viewMetadata"));
    }

    public static boolean isMakeWatermarkEnabled(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentInstanceId, "watermark"));
    }

    private static String getWatermarkIdForOriginalResolution(String componentInstanceId) {
        String watermarkHD = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentInstanceId, "WatermarkHD");
        if (!StringUtil.isInteger((String)watermarkHD)) {
            watermarkHD = "";
        }
        return watermarkHD;
    }

    private static String getWatermarkIdForThumbnailResolution(String componentInstanceId) {
        String watermarkOther = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentInstanceId, "WatermarkOther");
        if (!StringUtil.isInteger((String)watermarkOther)) {
            watermarkOther = "";
        }
        return watermarkOther;
    }

    public static Integer getWatermarkSize(String bundlePartOfWaterwarkSizeLabel) {
        String tmpValue = GalleryComponentSettings.getSettings().getString("sizeWatermark" + bundlePartOfWaterwarkSizeLabel, null);
        return StringUtil.isInteger((String)tmpValue) ? Integer.valueOf(tmpValue) : null;
    }

    public static int getMaxNumberOfPreviewThumbnail() {
        return ThumbnailPeriod.ALL_VALIDS.size();
    }

    public static Watermark getWatermark(String componentInstanceId) {
        Watermark watermark = new Watermark();
        watermark.setEnabled(GalleryComponentSettings.isMakeWatermarkEnabled(componentInstanceId));
        watermark.setIPTCPropertyForHD(GalleryComponentSettings.getWatermarkIdForOriginalResolution(componentInstanceId));
        watermark.setIPTCPropertyForThumbnails(GalleryComponentSettings.getWatermarkIdForThumbnailResolution(componentInstanceId));
        watermark.setTextForHD(OrganizationController.get().getComponentParameterValue(componentInstanceId, "WatermarkTextHD"));
        watermark.setTextForThumbnails(OrganizationController.get().getComponentParameterValue(componentInstanceId, "WatermarkTextOther"));
        watermark.setImageUrlForHD(componentInstanceId, OrganizationController.get().getComponentParameterValue(componentInstanceId, "WatermarkImageUrlHD"));
        watermark.setImageUrlForThumbnails(componentInstanceId, OrganizationController.get().getComponentParameterValue(componentInstanceId, "WatermarkImageUrlOther"));
        return watermark;
    }
}

