/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;

public class MultiGenerationMap<K, V>
implements Map<K, V> {
    private volatile CacheMap<K, V> write;
    private ConcurrentSkipListMap<Integer, CacheMap<K, V>> read = new ConcurrentSkipListMap();

    MultiGenerationMap() {
    }

    public void setWriteMap(CacheMap<K, V> m) {
        this.write = m;
    }

    public void addReadMap(int generation, CacheMap<K, V> m) {
        this.read.put(generation, m);
    }

    public void removeReadMap(int generation) {
        this.read.remove(generation);
    }

    @Override
    public V put(K key, V value) {
        CacheMap<K, V> m = this.write;
        if (m == null) {
            return null;
        }
        return m.put(key, value);
    }

    @Override
    public V get(Object key) {
        ValueWithGenerationInfo<V> value = this.readValue(key);
        if (value == null) {
            return null;
        }
        if (!value.isCurrentGeneration()) {
            this.put(key, value.value);
        }
        return value.getValue();
    }

    ValueWithGenerationInfo<V> readValue(Object key) {
        for (int generation : this.read.descendingKeySet()) {
            V value;
            CacheMap<K, V> m = this.read.get(generation);
            if (m == null || (value = m.get(key)) == null) continue;
            return new ValueWithGenerationInfo<V>(value, m == this.write);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int generation : this.read.descendingKeySet()) {
            CacheMap<K, V> m = this.read.get(generation);
            if (m == null || !m.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        return this.write.remove(key);
    }

    @Override
    public void clear() {
        this.write.clear();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    static class ValueWithGenerationInfo<V> {
        private final V value;
        private final boolean isCurrentGeneration;

        private ValueWithGenerationInfo(V value, boolean isCurrentGeneration) {
            this.value = value;
            this.isCurrentGeneration = isCurrentGeneration;
        }

        V getValue() {
            return this.value;
        }

        boolean isCurrentGeneration() {
            return this.isCurrentGeneration;
        }
    }
}

