/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenAuthentication;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.TokenProviderCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(TokenLoginModule.class);
    private TokenProvider tokenProvider;
    private TokenCredentials tokenCredentials;
    private TokenInfo tokenInfo;
    private Principal principal;
    private Set<? extends Principal> principals;
    private AuthInfo authInfo;

    public boolean login() throws LoginException {
        this.tokenProvider = this.getTokenProvider();
        if (this.tokenProvider == null) {
            return false;
        }
        Credentials credentials = this.getCredentials();
        if (credentials instanceof TokenCredentials) {
            TokenCredentials tc = (TokenCredentials)credentials;
            TokenAuthentication authentication = new TokenAuthentication(this.tokenProvider, this.getLoginModuleMonitor());
            if (authentication.authenticate((Credentials)tc)) {
                this.tokenCredentials = tc;
                this.tokenInfo = authentication.getTokenInfo();
                this.principal = authentication.getUserPrincipal();
                log.debug("Login: adding login name to shared state.");
                this.sharedState.put("javax.security.auth.login.name", this.tokenInfo.getUserId());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() throws LoginException {
        block6: {
            if (this.tokenCredentials != null && this.tokenInfo != null) {
                this.principals = this.principal != null ? this.getPrincipals(this.principal) : this.getPrincipals(this.tokenInfo.getUserId());
                this.authInfo = TokenLoginModule.getAuthInfo(this.tokenInfo, Iterables.concat(this.principals, this.subject.getPrincipals()));
                TokenLoginModule.updateSubject(this.subject, this.tokenCredentials, this.authInfo);
                this.closeSystemSession();
                return true;
            }
            try {
                TokenInfo ti;
                Credentials shared;
                if (this.tokenProvider == null || !this.sharedState.containsKey("org.apache.jackrabbit.credentials") || (shared = this.getSharedCredentials()) == null || !this.tokenProvider.doCreateToken(shared)) break block6;
                Root r = this.getRoot();
                if (r != null) {
                    r.refresh();
                }
                if ((ti = this.tokenProvider.createToken(shared)) != null) {
                    TokenCredentials tc = new TokenCredentials(ti.getToken());
                    ti.getPrivateAttributes().forEach((key, value) -> tc.setAttribute(key, value));
                    ti.getPublicAttributes().forEach((key, value) -> tc.setAttribute(key, value));
                    this.sharedState.put("javax.security.auth.login.attributes", ti.getPublicAttributes());
                    TokenLoginModule.updateSubject(this.subject, tc, null);
                    break block6;
                }
                this.onError();
                Object logId = this.sharedState.get("javax.security.auth.login.name");
                log.error("TokenProvider failed to create a login token for user {}", logId);
                throw new LoginException("Failed to create login token for user " + logId);
            }
            finally {
                this.clearState();
            }
        }
        return false;
    }

    public boolean logout() throws LoginException {
        Set creds = Stream.of(this.tokenCredentials, this.authInfo).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.logout(creds.isEmpty() ? null : creds, this.principals);
    }

    @NotNull
    protected Set<Class> getSupportedCredentials() {
        return Collections.singleton(TokenCredentials.class);
    }

    protected void clearState() {
        super.clearState();
        this.tokenCredentials = null;
        this.tokenInfo = null;
        this.tokenProvider = null;
        this.principal = null;
        this.principals = null;
        this.authInfo = null;
    }

    @Nullable
    private TokenProvider getTokenProvider() {
        TokenProvider provider = null;
        SecurityProvider securityProvider = this.getSecurityProvider();
        Root root = this.getRoot();
        if (root != null && securityProvider != null) {
            TokenConfiguration tokenConfig = (TokenConfiguration)securityProvider.getConfiguration(TokenConfiguration.class);
            provider = tokenConfig.getTokenProvider(root);
        }
        if (provider == null && this.callbackHandler != null) {
            try {
                TokenProviderCallback tcCallback = new TokenProviderCallback();
                this.callbackHandler.handle(new Callback[]{tcCallback});
                provider = tcCallback.getTokenProvider();
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return provider;
    }

    @NotNull
    private static AuthInfo getAuthInfo(@NotNull TokenInfo tokenInfo, @NotNull Iterable<? extends Principal> principals) {
        HashMap attributes = new HashMap();
        tokenInfo.getPublicAttributes().forEach((key, value) -> attributes.put(key, value));
        return new AuthInfoImpl(tokenInfo.getUserId(), attributes, principals);
    }

    private static void updateSubject(@NotNull Subject subject, @NotNull TokenCredentials tc, @Nullable AuthInfo authInfo) {
        if (!subject.isReadOnly()) {
            subject.getPublicCredentials().add(tc);
            if (authInfo != null) {
                subject.getPrincipals().addAll(authInfo.getPrincipals());
                TokenLoginModule.setAuthInfo((AuthInfo)authInfo, (Subject)subject);
            }
        }
    }
}

