/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.fulltext.LikePattern;

public enum Operator {
    EQUAL("="){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return PropertyValues.match((PropertyValue)p1, (PropertyValue)p2);
        }
    }
    ,
    NOT_EQUAL("<>"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return PropertyValues.notMatch((PropertyValue)p1, (PropertyValue)p2);
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo((Object)p2) > 0;
        }
    }
    ,
    GREATER_OR_EQUAL(">="){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo((Object)p2) >= 0;
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo((Object)p2) < 0;
        }
    }
    ,
    LESS_OR_EQUAL("<="){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            return p1.compareTo((Object)p2) <= 0;
        }
    }
    ,
    LIKE("like"){

        @Override
        public boolean evaluate(PropertyValue p1, PropertyValue p2) {
            LikePattern like = new LikePattern((String)p2.getValue(Type.STRING));
            for (String s : (Iterable)p1.getValue(Type.STRINGS)) {
                if (!like.matches(s)) continue;
                return true;
            }
            return false;
        }
    };

    private final String name;

    private Operator(String name) {
        this.name = name;
    }

    public abstract boolean evaluate(PropertyValue var1, PropertyValue var2);

    public String toString() {
        return this.name;
    }
}

