/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.plugins.document.RevisionGCStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.RevisionGCStatsMBean;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

class RevisionGCStats
implements RevisionGCStatsCollector,
RevisionGCStatsMBean {
    static final String RGC = "RevisionGC";
    static final String READ_DOC = "READ_DOC";
    static final String DELETE_DOC = "DELETE_DOC";
    static final String DELETE_LEAF_DOC = "DELETE_LEAF_DOC";
    static final String DELETE_SPLIT_DOC = "DELETE_SPLIT_DOC";
    static final String DELETE_INT_SPLIT_DOC = "DELETE_INT_SPLIT_DOC";
    static final String RESET_DELETED_FLAG = "RESET_DELETED_FLAG";
    static final String ACTIVE_TIMER = "ACTIVE_TIMER";
    static final String READ_DOC_TIMER = "READ_DOC_TIMER";
    static final String CHECK_DELETED_TIMER = "CHECK_DELETED_TIMER";
    static final String SORT_IDS_TIMER = "SORT_IDS_TIMER";
    static final String RESET_DELETED_FLAG_TIMER = "RESET_DELETED_FLAG_TIMER";
    static final String DELETE_DOC_TIMER = "DELETE_DOC_TIMER";
    static final String DELETE_SPLIT_DOC_TIMER = "DELETE_SPLIT_DOC_TIMER";
    static final String COUNTER = "COUNTER";
    static final String FAILURE_COUNTER = "FAILURE";
    private final StatisticsProvider provider;
    private final MeterStats readDoc;
    private final MeterStats deletedDoc;
    private final MeterStats deletedLeafDoc;
    private final MeterStats deletedSplitDoc;
    private final MeterStats deletedIntSplitDoc;
    private final MeterStats resetDeletedFlag;
    private final TimerStats activeTimer;
    private final TimerStats readDocTimer;
    private final TimerStats checkDeletedTimer;
    private final TimerStats sortIdsTimer;
    private final TimerStats resetDeletedFlagTimer;
    private final TimerStats deletedDocTimer;
    private final TimerStats deletedSplitDocTimer;
    private final CounterStats counter;
    private final CounterStats failureCounter;

    RevisionGCStats(StatisticsProvider provider) {
        this.provider = provider;
        this.readDoc = RevisionGCStats.meter(provider, READ_DOC);
        this.deletedDoc = RevisionGCStats.meter(provider, DELETE_DOC);
        this.deletedLeafDoc = RevisionGCStats.meter(provider, DELETE_LEAF_DOC);
        this.deletedSplitDoc = RevisionGCStats.meter(provider, DELETE_SPLIT_DOC);
        this.deletedIntSplitDoc = RevisionGCStats.meter(provider, DELETE_INT_SPLIT_DOC);
        this.resetDeletedFlag = RevisionGCStats.meter(provider, RESET_DELETED_FLAG);
        this.activeTimer = RevisionGCStats.timer(provider, ACTIVE_TIMER);
        this.readDocTimer = RevisionGCStats.timer(provider, READ_DOC_TIMER);
        this.checkDeletedTimer = RevisionGCStats.timer(provider, CHECK_DELETED_TIMER);
        this.sortIdsTimer = RevisionGCStats.timer(provider, SORT_IDS_TIMER);
        this.resetDeletedFlagTimer = RevisionGCStats.timer(provider, RESET_DELETED_FLAG_TIMER);
        this.deletedDocTimer = RevisionGCStats.timer(provider, DELETE_DOC_TIMER);
        this.deletedSplitDocTimer = RevisionGCStats.timer(provider, DELETE_SPLIT_DOC_TIMER);
        this.counter = RevisionGCStats.counter(provider, COUNTER);
        this.failureCounter = RevisionGCStats.counter(provider, FAILURE_COUNTER);
    }

    @Override
    public void documentRead() {
        this.readDoc.mark();
    }

    @Override
    public void documentsDeleted(long numDocs) {
        this.deletedDoc.mark(numDocs);
    }

    @Override
    public void leafDocumentsDeleted(long numDocs) {
        this.deletedDoc.mark(numDocs);
        this.deletedLeafDoc.mark(numDocs);
    }

    @Override
    public void splitDocumentsDeleted(long numDocs) {
        this.deletedDoc.mark(numDocs);
        this.deletedSplitDoc.mark(numDocs);
    }

    @Override
    public void intermediateSplitDocumentsDeleted(long numDocs) {
        this.deletedIntSplitDoc.mark(numDocs);
    }

    @Override
    public void deletedOnceFlagReset() {
        this.resetDeletedFlag.mark();
    }

    @Override
    public void started() {
        this.counter.inc();
    }

    @Override
    public void finished(VersionGarbageCollector.VersionGCStats stats) {
        this.activeTimer.update(stats.active.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        this.readDocTimer.update(stats.collectDeletedDocsElapsed, TimeUnit.MICROSECONDS);
        this.checkDeletedTimer.update(stats.checkDeletedDocsElapsed, TimeUnit.MICROSECONDS);
        this.deletedDocTimer.update(stats.deleteDeletedDocsElapsed, TimeUnit.MICROSECONDS);
        this.deletedSplitDocTimer.update(stats.collectAndDeleteSplitDocsElapsed, TimeUnit.MICROSECONDS);
        this.sortIdsTimer.update(stats.sortDocIdsElapsed, TimeUnit.MICROSECONDS);
        this.resetDeletedFlagTimer.update(stats.updateResurrectedDocumentsElapsed, TimeUnit.MICROSECONDS);
        if (!stats.success) {
            this.failureCounter.inc();
        }
    }

    @Override
    public long getReadDocCount() {
        return this.readDoc.getCount();
    }

    @Override
    public long getDeletedDocCount() {
        return this.deletedDoc.getCount();
    }

    @Override
    public long getDeletedLeafDocCount() {
        return this.deletedLeafDoc.getCount();
    }

    @Override
    public long getDeletedSplitDocCount() {
        return this.deletedSplitDoc.getCount();
    }

    @Override
    public long getDeletedIntSplitDocCount() {
        return this.deletedIntSplitDoc.getCount();
    }

    @Override
    public long getResetDeletedFlagCount() {
        return this.resetDeletedFlag.getCount();
    }

    @Override
    public CompositeData getReadDocHistory() {
        return this.getTimeSeriesData(READ_DOC, "Documents read by RevisionGC");
    }

    @Override
    public CompositeData getDeletedDocHistory() {
        return this.getTimeSeriesData(DELETE_DOC, "Documents deleted by RevisionGC");
    }

    @Override
    public CompositeData getDeletedLeafDocHistory() {
        return this.getTimeSeriesData(DELETE_LEAF_DOC, "Leaf documents deleted by RevisionGC");
    }

    @Override
    public CompositeData getDeletedSplitDocHistory() {
        return this.getTimeSeriesData(DELETE_SPLIT_DOC, "Split documents deleted by RevisionGC");
    }

    @Override
    public CompositeData getDeletedIntSplitDocHistory() {
        return this.getTimeSeriesData(DELETE_INT_SPLIT_DOC, "Intermediate split documents deleted by RevisionGC");
    }

    @Override
    public CompositeData getResetDeletedFlagHistory() {
        return this.getTimeSeriesData(RESET_DELETED_FLAG, "Deleted once flags reset by RevisionGC");
    }

    private static MeterStats meter(StatisticsProvider provider, String name) {
        return provider.getMeter(RevisionGCStats.qualifiedName(name), StatsOptions.DEFAULT);
    }

    private static TimerStats timer(StatisticsProvider provider, String name) {
        return provider.getTimer(RevisionGCStats.qualifiedName(name), StatsOptions.METRICS_ONLY);
    }

    private static CounterStats counter(StatisticsProvider provider, String name) {
        return provider.getCounterStats(RevisionGCStats.qualifiedName(name), StatsOptions.METRICS_ONLY);
    }

    private static String qualifiedName(String metricName) {
        return "RevisionGC." + metricName;
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(name), (String)desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.provider.getStats().getTimeSeries(RevisionGCStats.qualifiedName(name), true);
    }
}

