/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.json;

import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.jetbrains.annotations.Nullable;

public class JsopBuilder
implements JsopWriter {
    private static final boolean JSON_NEWLINES = false;
    private StringBuilder buff = new StringBuilder();
    private boolean needComma;
    private int lineLength;
    private int previous;

    @Override
    public void resetWriter() {
        this.needComma = false;
        this.buff.setLength(0);
    }

    @Override
    public void setLineLength(int length) {
        this.lineLength = length;
    }

    @Override
    public JsopBuilder append(JsopWriter buffer) {
        this.appendTag(buffer.toString());
        return this;
    }

    @Override
    public JsopBuilder tag(char tag) {
        this.buff.append(tag);
        this.needComma = false;
        return this;
    }

    private JsopBuilder appendTag(String string) {
        this.buff.append(string);
        this.needComma = false;
        return this;
    }

    @Override
    public JsopBuilder newline() {
        this.buff.append('\n');
        return this;
    }

    @Override
    public JsopBuilder object() {
        this.optionalCommaAndNewline(1);
        this.buff.append('{');
        this.needComma = false;
        return this;
    }

    @Override
    public JsopBuilder endObject() {
        this.buff.append('}');
        this.needComma = true;
        return this;
    }

    @Override
    public JsopBuilder array() {
        this.optionalCommaAndNewline(1);
        this.buff.append('[');
        this.needComma = false;
        return this;
    }

    @Override
    public JsopBuilder endArray() {
        this.buff.append(']');
        this.needComma = true;
        return this;
    }

    @Override
    public JsopBuilder key(String name) {
        this.optionalCommaAndNewline(name.length());
        this.buff.append(JsopBuilder.encode(name)).append(':');
        this.needComma = false;
        return this;
    }

    @Override
    public JsopBuilder value(long value) {
        return this.encodedValue(Long.toString(value));
    }

    @Override
    public JsopBuilder value(boolean value) {
        return this.encodedValue(Boolean.toString(value));
    }

    @Override
    public JsopBuilder value(String value) {
        return this.encodedValue(JsopBuilder.encode(value));
    }

    @Override
    public JsopBuilder encodedValue(String value) {
        this.optionalCommaAndNewline(this.strLength(value));
        this.buff.append(value);
        this.needComma = true;
        return this;
    }

    private int strLength(@Nullable String value) {
        if (value != null) {
            return value.length();
        }
        return "null".length();
    }

    private void optionalCommaAndNewline(int add) {
        int len;
        if (this.needComma) {
            this.buff.append(',');
        }
        if (this.lineLength > 0 && (len = this.buff.length()) > this.lineLength / 4 && len + add - this.previous > this.lineLength) {
            this.buff.append('\n');
            this.previous = len;
        }
    }

    public String toString() {
        return this.buff.toString();
    }

    public static String encode(String s) {
        if (s == null) {
            return "null";
        }
        int length = s.length();
        if (length == 0) {
            return "\"\"";
        }
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '\\' && c >= ' ' && (c < '\ud800' || c > '\udbff')) continue;
            StringBuilder buff = new StringBuilder(length + 2 + length / 8);
            buff.append('\"');
            JsopBuilder.escape(s, length, buff);
            return buff.append('\"').toString();
        }
        StringBuilder buff = new StringBuilder(length + 2);
        return buff.append('\"').append(s).append('\"').toString();
    }

    public static void escape(String s, StringBuilder buff) {
        JsopBuilder.escape(s, s.length(), buff);
    }

    private static void escape(String s, int length, StringBuilder buff) {
        block9: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buff.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buff.append("\\b");
                    continue block9;
                }
                case '\f': {
                    buff.append("\\f");
                    continue block9;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block9;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        buff.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    if (c >= '\ud800' && c <= '\udbff') {
                        if (i < length - 1 && Character.isSurrogatePair(c, s.charAt(i + 1))) {
                            buff.append(c);
                            buff.append(s.charAt(i + 1));
                            ++i;
                            continue block9;
                        }
                        buff.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    buff.append(c);
                }
            }
        }
    }

    public int length() {
        return this.buff.length();
    }

    public static String prettyPrint(String jsop) {
        StringBuilder buff = new StringBuilder();
        JsopTokenizer t = new JsopTokenizer(jsop);
        do {
            JsopBuilder.prettyPrint(buff, t, "  ");
        } while (t.getTokenType() != 0);
        return buff.toString();
    }

    static String prettyPrint(StringBuilder buff, JsopTokenizer t, String ident) {
        Object space = "";
        boolean inArray = false;
        block10: while (true) {
            int token = t.read();
            switch (token) {
                case 0: {
                    return buff.toString();
                }
                case 1: {
                    buff.append('\"').append(t.getEscapedToken()).append('\"');
                    continue block10;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buff.append(t.getEscapedToken());
                    continue block10;
                }
                case 123: {
                    if (t.matches(125)) {
                        buff.append("{}");
                        continue block10;
                    }
                    space = (String)space + ident;
                    buff.append("{\n").append((String)space);
                    continue block10;
                }
                case 125: {
                    space = ((String)space).substring(0, ((String)space).length() - ident.length());
                    buff.append('\n').append((String)space).append("}");
                    continue block10;
                }
                case 91: {
                    inArray = true;
                    buff.append("[");
                    continue block10;
                }
                case 93: {
                    inArray = false;
                    buff.append("]");
                    continue block10;
                }
                case 44: {
                    if (!inArray) {
                        buff.append(",\n").append((String)space);
                        continue block10;
                    }
                    buff.append(", ");
                    continue block10;
                }
            }
            buff.append((char)token).append(' ');
        }
    }
}

