/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationParameters
implements Map<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationParameters.class);
    public static final ConfigurationParameters EMPTY = new ConfigurationParameters();
    private final Map<String, Object> options;

    private ConfigurationParameters() {
        this.options = Collections.emptyMap();
    }

    private ConfigurationParameters(@NotNull Map<String, ?> options) {
        this.options = Collections.unmodifiableMap(options);
    }

    @NotNull
    public static ConfigurationParameters of(ConfigurationParameters ... params) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (ConfigurationParameters cp : params) {
            if (cp == null) continue;
            m.putAll(cp.options);
        }
        return m.isEmpty() ? EMPTY : new ConfigurationParameters(m);
    }

    @NotNull
    public static ConfigurationParameters of(@NotNull Properties properties) {
        if (properties.isEmpty()) {
            return EMPTY;
        }
        HashMap<String, Object> options = new HashMap<String, Object>(properties.size());
        for (Object name : properties.keySet()) {
            String key = name.toString();
            options.put(key, properties.get(key));
        }
        return new ConfigurationParameters(options);
    }

    @NotNull
    public static ConfigurationParameters of(@NotNull Dictionary<String, Object> properties) {
        if (properties.isEmpty()) {
            return EMPTY;
        }
        HashMap<String, Object> options = new HashMap<String, Object>(properties.size());
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            options.put(key, properties.get(key));
        }
        return new ConfigurationParameters(options);
    }

    @NotNull
    public static ConfigurationParameters of(@NotNull Map<?, ?> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        if (map instanceof ConfigurationParameters) {
            return (ConfigurationParameters)map;
        }
        HashMap options = new HashMap(map.size());
        map.forEach((key, value) -> options.put(String.valueOf(key), value));
        return new ConfigurationParameters(options);
    }

    @NotNull
    public static ConfigurationParameters of(@NotNull String key, @NotNull Object value) {
        return new ConfigurationParameters((Map<String, ?>)ImmutableMap.of((Object)key, (Object)value));
    }

    @NotNull
    public static ConfigurationParameters of(@NotNull String key1, @NotNull Object value1, @NotNull String key2, @NotNull Object value2) {
        return new ConfigurationParameters((Map<String, ?>)ImmutableMap.of((Object)key1, (Object)value1, (Object)key2, (Object)value2));
    }

    public boolean contains(@NotNull String key) {
        return this.options.containsKey(key);
    }

    @Nullable
    public <T> T getConfigValue(@NotNull String key, @Nullable T defaultValue, @Nullable Class<T> targetClass) {
        if (this.options.containsKey(key)) {
            Object property = this.options.get(key);
            return property == null ? null : (T)ConfigurationParameters.convert(property, ConfigurationParameters.getTargetClass(property, defaultValue, targetClass));
        }
        return defaultValue;
    }

    @NotNull
    public <T> T getConfigValue(@NotNull String key, @NotNull T defaultValue) {
        Object property = this.options.get(key);
        if (property == null) {
            return defaultValue;
        }
        T value = ConfigurationParameters.convert(property, ConfigurationParameters.getTargetClass(property, defaultValue, null));
        return value == null ? defaultValue : value;
    }

    @NotNull
    private static Class<?> getTargetClass(@NotNull Object configProperty, @Nullable Object defaultValue, @Nullable Class<?> targetClass) {
        Class<?> clazz = targetClass;
        if (clazz == null) {
            clazz = defaultValue == null ? configProperty.getClass() : defaultValue.getClass();
        }
        return clazz;
    }

    @Nullable
    private static <T> T convert(@NotNull Object configProperty, @NotNull Class<?> clazz) {
        String str = configProperty.toString();
        if (clazz.isAssignableFrom(configProperty.getClass())) {
            return (T)configProperty;
        }
        if (clazz == String.class) {
            return (T)str;
        }
        if (clazz == Milliseconds.class) {
            Milliseconds ret = Milliseconds.of(str);
            return (T)(ret == null ? null : ret);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(str);
        }
        if (clazz == String[].class) {
            return (T)PropertiesUtil.toStringArray((Object)configProperty);
        }
        if (clazz == Set.class || Set.class.isAssignableFrom(clazz)) {
            return (T)ConfigurationParameters.convertToSet(configProperty, clazz);
        }
        return (T)ConfigurationParameters.convertToNumber(str, clazz);
    }

    @NotNull
    private static Object convertToNumber(@NotNull String str, @NotNull Class<?> clazz) {
        try {
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(str);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(str);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(str);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(str);
            }
            log.warn("Unsupported target type {} for value {}", (Object)clazz.getName(), (Object)str);
            throw ConfigurationParameters.conversionFailedException(str, clazz.getName(), null);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value {}; cannot be parsed into {}", (Object)str, (Object)clazz.getName());
            throw ConfigurationParameters.conversionFailedException(str, clazz.getName(), e);
        }
    }

    @NotNull
    private static Set<?> convertToSet(@NotNull Object configProperty, @NotNull Class<?> clazz) {
        if (configProperty instanceof Set) {
            return (Set)configProperty;
        }
        if (configProperty instanceof Collection) {
            return ImmutableSet.copyOf((Collection)((Collection)configProperty));
        }
        if (configProperty.getClass().isArray()) {
            return ImmutableSet.copyOf((Object[])((Object[])configProperty));
        }
        Object[] arr = PropertiesUtil.toStringArray((Object)configProperty);
        if (arr != null) {
            return ImmutableSet.copyOf((Object[])arr);
        }
        String str = configProperty.toString();
        log.warn("Unsupported target type {} for value {}", (Object)clazz.getName(), (Object)str);
        throw ConfigurationParameters.conversionFailedException(str, clazz.getName(), null);
    }

    @NotNull
    private static IllegalArgumentException conversionFailedException(@NotNull String str, @NotNull String className, @Nullable Exception e) {
        return new IllegalArgumentException("Cannot convert config entry " + str + " to " + className, e);
    }

    @Override
    public int size() {
        return this.options.size();
    }

    @Override
    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.options.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.options.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.options.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.options.keySet();
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        return this.options.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.options.entrySet();
    }

    public static final class Milliseconds {
        private static final Pattern pattern = Pattern.compile("(\\d+)(\\.\\d+)?(ms|s|m|h|d)?");
        public static final Milliseconds NULL = new Milliseconds(0L);
        public static final Milliseconds FOREVER = new Milliseconds(Long.MAX_VALUE);
        public static final Milliseconds NEVER = new Milliseconds(-1L);
        public final long value;

        private Milliseconds(long value) {
            this.value = value;
        }

        public static Milliseconds of(long value) {
            if (value == 0L) {
                return NULL;
            }
            if (value == Long.MAX_VALUE) {
                return FOREVER;
            }
            if (value < 0L) {
                return NEVER;
            }
            return new Milliseconds(value);
        }

        @Nullable
        public static Milliseconds of(@Nullable String str) {
            if (str == null) {
                return null;
            }
            Matcher m = pattern.matcher(str);
            long current = -1L;
            while (m.find()) {
                Object number = m.group(1);
                String decimal = m.group(2);
                if (decimal != null) {
                    number = (String)number + decimal;
                }
                String unit = m.group(3);
                double value = Double.parseDouble((String)number);
                if ("s".equals(unit)) {
                    value *= 1000.0;
                } else if ("m".equals(unit)) {
                    value *= 60000.0;
                } else if ("h".equals(unit)) {
                    value *= 3600000.0;
                } else if ("d".equals(unit)) {
                    value *= 8.64E7;
                }
                current = (long)((double)current + value);
            }
            return current < 0L ? null : new Milliseconds(current + 1L);
        }

        @NotNull
        public static Milliseconds of(@Nullable String str, @NotNull Milliseconds defaultValue) {
            if (str == null) {
                return defaultValue;
            }
            Milliseconds ms = Milliseconds.of(str);
            return ms == null ? defaultValue : ms;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.value == ((Milliseconds)o).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }
}

