/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;

class KmeliaServiceContext {
    KmeliaServiceContext() {
    }

    static void createdIntoRequestContext(PublicationDetail publication) {
        String cacheKey = KmeliaServiceContext.buildKey("publicationCreation", publication);
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)cacheKey, (Object)Boolean.TRUE);
    }

    static boolean hasPublicationBeenCreatedFromRequestContext(PublicationDetail publication) {
        String cacheKey = KmeliaServiceContext.buildKey("publicationCreation", publication);
        return Boolean.TRUE == CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)cacheKey, Boolean.class);
    }

    static void updatedIntoRequestContext(PublicationDetail publication) {
        String cacheKey = KmeliaServiceContext.buildKey("publicationModification", publication);
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)cacheKey, (Object)Boolean.TRUE);
    }

    static boolean hasPublicationBeenUpdatedFromRequestContext(PublicationDetail publication) {
        String cacheKey = KmeliaServiceContext.buildKey("publicationModification", publication);
        return Boolean.TRUE == CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)cacheKey, Boolean.class);
    }

    private static String buildKey(String prefix, PublicationDetail publication) {
        return prefix + "@" + publication.getInstanceId() + "@" + publication.getId();
    }
}

