/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.dao;

import java.sql.SQLException;
import java.util.List;
import org.silverpeas.components.kmelia.dao.TopicSearchDao;
import org.silverpeas.components.kmelia.model.MostInterestedQueryVO;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Repository
public class TopicSearchDaoImpl
implements TopicSearchDao {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.kmelia.settings.kmeliaSettings");
    private static final String QUERY = "query";

    @Override
    public List<MostInterestedQueryVO> getMostInterestedSearch(String instanceId) {
        JdbcSqlQuery jdbcSqlQuery = JdbcSqlQuery.select((String)"count(*) as nb, query").from(new String[]{"sc_kmelia_search"}).where("instanceid = ?", new Object[]{instanceId}).groupBy(new String[]{QUERY, "language"}).orderBy(new String[]{"nb DESC", QUERY}).configure(config -> config.withResultLimit(settings.getInteger("kmelia.stats.most.interested.query.limit", 10)));
        ListSlice mostInterestedQueries = null;
        try {
            mostInterestedQueries = jdbcSqlQuery.execute(row -> new MostInterestedQueryVO(row.getString(QUERY), row.getInt("nb")));
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error("Problem to execute SQL query " + jdbcSqlQuery.getSqlQuery() + " with intanceId = " + instanceId, (Throwable)e);
        }
        return mostInterestedQueries;
    }
}

